function selected = DCsGUI(varNames)

    %%%have some test data
    if (nargin == 0)
        varNames{1} = 'this is one';
        varNames{2} = 'I know two';
        varNames{30} = 'hellow third world';
    end

    %%%New figure
    fh = figure('Position',[250 250 350 350],...
                'Name','Select Variables',...
                'MenuBar','none', ...
                'Units'     , 'characters'    , ...
                'ResizeFcn' , @myResizeFcn);

    %%%set up button
    button = uicontrol(fh,          ...
      'Style'     , 'Pushbutton', ...
      'Units'     , 'characters'    , ...
      'String'    , 'Use Selected'     , ...
      'Callback'  , @varButtonFcn);

    %%Listbox
    lb = uicontrol(fh,          ...
      'Style'     , 'Listbox', ...
      'Units'     , 'characters'    , ...
      'String'    , varNames,...
      'max',2,'min',0);

%     %%%Checkboxes
%     for i=1:length(varNames)
%         cb(i) = uicontrol(fh,          ...
%           'Style'     , 'checkbox', ...
%           'Units'     , 'characters'    , ...
%           'String'    , varNames{i}     );  
%     %%%Static positioning
%         set(cb(i), 'Position',[4, (length(varNames)*2.5) - (i*2.5-20) ,30,1.154]);
%     end

%%%To keep all the controls in the right place
    function myResizeFcn(varargin)
        % Figure resize callback
        %   Adjust object positions so that they maintain appropriate
        %   proportions

        fP = get(fh, 'Position') ;   
        set(button, 'Position', [10,  2, fP(3)-20, 1.5]);
        set(lb  , 'Position',   [10,  3.5, fP(3)-20, (fP(4)-5)]);
%         set(cb  , 'Position', [50       , 85, fP(3)-100, fP(4)-130]);
    
    end
    
%%%button callback
    function varButtonFcn(varargin)
        set(fh, 'UserData', 'pressed');
    end
    

    %%%Don't do anything until the button is pressed
    waitfor(fh, 'UserData');
    %%%Set the output to be the indicies of selected
    selected = get(lb, 'Value');
    %%%close the figure
    close(fh);

end
