import java.util.ArrayList;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import javax.swing.border.EmptyBorder;
import javax.swing.*;
import javax.swing.colorchooser.*;
 
public class unitOptionPanel extends JDialog implements ActionListener,
                                          ChangeListener {
 
    private String response;
    
    private JTextField		nameField;
    private JTextField[]	sunameFields;
	private JTextField[]	suprefixFields;
	private JTextField[]	suexponentFields;
	private JTextField[]	sumultiplyerFields;
	private JTextField[]	suoffsetFields;
	
	private Unit unit;
	/**
     * Class Constructor.
     */
	public unitOptionPanel( JFrame parent, boolean modal, Unit unitin ) {
		super( parent , modal );
		unit = unitin;
		setSize(600, 400);
		setLocationRelativeTo( null );
		initComponents(unit);
		
    }
 
	/**
     * This method is called within the constructor to
     * initialize the form.
     */
	private void initComponents(Unit unit) {
        setTitle( "Edit " + unit.getName());
        setResizable( true );
        	
    	JPanel pane = new JPanel(); 
		pane.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.weightx = 1;
		c.weighty = 0;
		c.gridwidth = 1;
		c.gridheight = 1;
		
		
		JLabel nameLabel = new JLabel("Name: ");
		c.gridx = 0;
		c.gridy = 0;
		pane.add(nameLabel, c);
		nameField = new JTextField(unit.getName(), 15);
		c.gridx = 1;
		c.gridy = 0;
		pane.add(nameField, c);
		
		JButton add = new JButton("Add subunit");
		c.gridx = 3;
		c.gridy = 0;
        add.addActionListener(this);
		pane.add(add, c);
		
		//Set up the row titles
		JLabel label;
		label = new JLabel("Unit");
		c.gridx = 0;
		c.gridwidth = 2;
		c.gridy = 1;
		pane.add(label,c);
		label = new JLabel("Prefix");
		c.gridx = 2;
		c.gridwidth = 1;
		c.gridy = 1;
		pane.add(label,c);
		label = new JLabel("Mult");
		c.gridx = 3;
		c.gridy = 1;
		pane.add(label,c);
		label = new JLabel("Offset");
		c.gridx = 4;
		c.gridy = 1;
		pane.add(label,c);
		label = new JLabel("Expo");
		c.gridx = 5;
		c.gridy = 1;
		pane.add(label,c);
		
		//Fill down with the subUnits
		int maxSubs = unit.getSubUnits().size();
		sunameFields = new JTextField[maxSubs];
		suprefixFields = new JTextField[maxSubs];
		suexponentFields = new JTextField[maxSubs];
		sumultiplyerFields = new JTextField[maxSubs];
		suoffsetFields = new JTextField[maxSubs];
		
		for(int i=0; i<maxSubs; i++){
			Unit su = (Unit)unit.getSubUnits().get(i);
			sunameFields[i] = new JTextField(su.getName(),10);
			c.gridx = 0;
			c.gridwidth = 2;
			c.gridy = i+2;
			pane.add(sunameFields[i],c);
			String tempString;
			//PREFIX
			if(su.getPref() != null){
				tempString = su.getPref().trim();
			}
			else{
				tempString = "";
			}
			suprefixFields[i] = new JTextField(tempString,5);
			c.gridx = 2;
			c.gridwidth = 1;
			c.gridy = i+2;
			pane.add(suprefixFields[i],c);
			//MULT
			if(su.getMult() != null){
				tempString = su.getMult().toString().trim();
			}
			else{
				tempString = "";
			}
			sumultiplyerFields[i] = new JTextField(tempString,5);
			c.gridx = 3;
			c.gridy = i+2;
			pane.add(sumultiplyerFields[i],c);
			//OFFSET
			if(su.getOffset() != null){
				tempString = su.getOffset().toString().trim();
			}
			else{
				tempString = "";
			}
			suoffsetFields[i] = new JTextField(tempString,5);
			c.gridx = 4;
			c.gridy = i+2;
			pane.add(suoffsetFields[i],c);
			//EXPONENT
			if(su.getExpo() != null){
				tempString = su.getExpo().toString().trim();
			}
			else{
				tempString = "";
			}
			suexponentFields[i] = new JTextField(tempString,5);
			c.gridx = 5;
			c.gridy = i+2;
			pane.add(suexponentFields[i],c);	
		}

		
		//Put in the ok and cancel buttons
		JButton okBtn = new JButton( "OK" );
		c.weightx = 1;
		c.weighty = 0;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.gridwidth = 3;
		c.gridheight = 1;
		c.gridx = 0;
		c.gridy = maxSubs+2;
		pane.add(okBtn, c );
        okBtn.setActionCommand( "OK" );
        okBtn.addActionListener( new ButtonListener() );
                
        JButton cancelBtn = new JButton( "Cancel" );
		c.gridwidth = 3;
		c.gridheight = 1;
		c.gridx = 3;
		c.gridy = maxSubs+2;
		pane.add(cancelBtn, c );
        cancelBtn.setActionCommand( "Cancel" );
        cancelBtn.addActionListener( new ButtonListener() );

		getContentPane().add( BorderLayout.CENTER, pane );    
		pack();
	
	}
	public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
		if(command.equals("Add subunit")){
			//Update existing fields first
			ArrayList subs = getSubUnits();
			unit.setName(getNameField());
			unit.clearSubs();
			for(int i=0; i<subs.size(); i++){
				Unit u = (Unit)subs.get(i);
				unit.addSubUnit(u);
			}
			//Add new unit
			Unit tempu = new Unit();
			unit.addSubUnit(tempu);
			getContentPane().removeAll();
			initComponents(unit);	
		}
        
    }

    public void stateChanged(ChangeEvent e) {
    }

 
    /**
	 * @param args	The command line arguments.
	 */
	public static void main( String args[] ) {
		ArrayList units = new ArrayList();
        Unit flow = new Unit("flow");
        units.add(flow);
        Unit ml = new Unit("ml");
        units.add(ml);
        Unit litre = new Unit("litre");
        units.add(litre);
        Unit second = new Unit("second");
        units.add(second);
        
        litre.setPref("milli");
        ml.addSubUnit(litre);
        
        second.setExpo(-1.0);
        second.setOffset(-51.0);
        flow.addSubUnit(ml);
        flow.addSubUnit(second);
        
        new unitOptionPanel(new JFrame() , true, flow ).show();
		
	}
 
    /**
     * Returns the value of Input 1.
     *
     * @return String	Value of Input 1.
     */    
    public String getNameField() {
		String value = null;
		if (nameField.getText() != null) {
			value = nameField.getText();
		}	
    	return value;
    }
    public ArrayList getSubUnits(){
		ArrayList subUnits = new ArrayList();
		
		//get the names
		int numSubs = sunameFields.length;
		String[] names = new String[numSubs];
		String[] prefixes = new String[numSubs];
		Double[] exponents = new Double[numSubs];
		Double[] mults = new Double[numSubs];
		Double[] offsets = new Double[numSubs];
		for(int i=0; i<numSubs; i++){
		
			//Get the names
			names[i] = sunameFields[i].getText();	
    		//get the prefixes  		
			if(suprefixFields[i].getText() != null){
				prefixes[i] = suprefixFields[i].getText();
			}
			else{
				prefixes[i]="";
			}
			
			//get the exponents	    	
			if(suexponentFields[i].getText() != null){
				exponents[i] = Double.parseDouble(suexponentFields[i].getText().trim());
			}
			else{
				exponents[i] = 0.0;
			}		
				
			//get the multiplyer	    	
			if(sumultiplyerFields[i].getText() != null){
				mults[i] = Double.parseDouble(sumultiplyerFields[i].getText().trim());
			}
			else{
				mults[i] = 1.0;
			}
			//get the offsets	    	
			if(suoffsetFields[i].getText() != null){
				offsets[i] = Double.parseDouble(suoffsetFields[i].getText().trim());
			}
			else{
				offsets[i] = 0.0;
			}
			Unit tempu = new Unit(names[i], prefixes[i], exponents[i], mults[i], offsets[i]);
			subUnits.add(tempu);
		}
    	
    	
    	
    	return subUnits;
    }



    /**
     * Returns the response from the dialog box.
     *
     * @return String	Response string for dialog box.
	 *					equals "OK" if user hits OK.
	 *                  equals null if user cancels.
     */    
    public String getResponse() {
    	return response;
    }
 
    /**
	 * Action listener to listen to the buttons.
	 */
    class ButtonListener implements ActionListener {
        public void actionPerformed( ActionEvent e ) {
        	if ( e.getActionCommand().equals( "OK" ) ) {
                response = "OK";  
            	hide();
        	} else if ( e.getActionCommand().equals( "Cancel" ) ) {
                response = null;  
            	hide();
        	}
        }
    }
}
