
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import javax.swing.border.EmptyBorder;
import javax.swing.*;
import javax.swing.colorchooser.*;
 
public class myComponentOptionPanel extends JDialog implements ActionListener,
                                          ChangeListener {
 
    private String response;
    
    private JTextField	nameField;
    private JTextArea	equationsField;
	private Color color;
 	private JColorChooser tcc;
 	private JButton bcc;
 	private myComponent myC;
	/**
     * Class Constructor.
     */
	public myComponentOptionPanel( JFrame parent, boolean modal, myComponent c ) {
		super( parent , modal );
		myC = c;
		initComponents(c);
		setSize(400, 250);
		
    }
 
	/**
     * This method is called within the constructor to
     * initialize the form.
     */
	private void initComponents(myComponent comp) {
        setTitle( "Edit " + comp.getName());
        color =  comp.getColor();
        setResizable( true );
        setLocationRelativeTo( null );
 	
    	JPanel pane = new JPanel(); 
		pane.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.weightx = 1;
		c.weighty = 0;
		c.gridwidth = 1;
		c.gridheight = 1;
		
		
		JLabel nameLabel = new JLabel("Name: ");
		c.gridx = 0;
		c.gridy = 0;
		pane.add(nameLabel, c);
		nameField = new JTextField(comp.getName() + "   ");
		c.gridx = 1;
		c.gridy = 0;
		pane.add(nameField, c);
		bcc = new JButton("set colour");
 		c.gridx = 2;
		c.gridy = 0;
 		bcc.setBackground(color);
        bcc.addActionListener(this);
        pane.add(bcc, c);
		
		JButton button;
		int maxVars = Math.max(comp.numVarIn(), comp.numVarMid());
		maxVars = Math.max(maxVars, comp.numVarOut());
			
			
		for(int cv=0; cv< comp.numVarIn(); cv++){
			button = new JButton(comp.variableFromColRow(1,cv).getName());
			button.setBackground(comp.variableFromColRow(1,cv).getColor());
			button.addActionListener(this);
			c.fill = GridBagConstraints.HORIZONTAL;
			c.gridx = 0;
			c.gridy = cv+1;
			pane.add(button, c);
		}
		for(int cv=0; cv< comp.numVarMid(); cv++){
			button = new JButton(comp.variableFromColRow(2,cv).getName());
			button.setBackground(comp.variableFromColRow(2,cv).getColor());
			button.addActionListener(this);
			c.fill = GridBagConstraints.HORIZONTAL;
			c.gridx = 1;
			c.gridy = cv+1;
			pane.add(button, c);
		}
		for(int cv=0; cv< comp.numVarOut(); cv++){
			button = new JButton(comp.variableFromColRow(3,cv).getName());
			button.setBackground(comp.variableFromColRow(3,cv).getColor());
			button.addActionListener(this);
			c.fill = GridBagConstraints.HORIZONTAL;
			c.gridx = 2;
			c.gridy = cv+1;
			pane.add(button, c);
		}

		
		equationsField = new JTextArea(comp.getEquations());
		equationsField.setLineWrap(true);
        equationsField.setWrapStyleWord(true);
		JScrollPane Scroll = new JScrollPane( equationsField, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS );
		c.weightx = 1;
		c.weighty = 1;
		c.fill = GridBagConstraints.BOTH;
		c.gridwidth = 3;
		c.gridheight = 5;
		c.gridx = 0;
		c.gridy = maxVars+1;
		pane.add(Scroll, c);
	
		
		
		JButton okBtn = new JButton( "OK" );
		c.weightx = 1;
		c.weighty = 0;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.gridwidth = 2;
		c.gridheight = 1;
		c.gridx = 0;
		c.gridy = maxVars+8;
		pane.add(okBtn, c );
        okBtn.setActionCommand( "OK" );
        okBtn.addActionListener( new ButtonListener() );
                
        JButton cancelBtn = new JButton( "Cancel" );
		c.gridwidth = 2;
		c.gridheight = 1;
		c.gridx = 2;
		c.gridy = maxVars+8;
		pane.add(cancelBtn, c );
        cancelBtn.setActionCommand( "Cancel" );
        cancelBtn.addActionListener( new ButtonListener() );

		getContentPane().add( BorderLayout.CENTER, pane );    
		pack();
	
	}
	public void actionPerformed(ActionEvent e) {
        if(e.getSource() == bcc){
        	Color newColor = JColorChooser.showDialog(
                                       myComponentOptionPanel.this,
                                       "Choose Color",
                                       color);
	        if (newColor != null) {
	           color = newColor;
	           bcc.setBackground(color);
	        }
        }
        else{
        	final JButton button = (JButton)e.getSource();
        	Variable v = myC.variableByName(button.getText());
        	VariableOptionPanel md = new VariableOptionPanel(null, true, v);
  			md.setVisible( true );
			if (md.getResponse().equals("OK")) {
			    v.setName(md.getNameField());
			    button.setText(md.getNameField());
			    if( !(md.getInitField()== null) ){
			    	v.setInit(Double.parseDouble(md.getInitField()));	
			    }			    
			    v.setUnits(md.getUnitField());
			    v.setPub(md.getPubBox());
			    v.setColor(md.getColorField());
			    button.setBackground(md.getColorField());
			    myC.updateVariableRows();
			    md.dispose();
			} else {
			    md.dispose();
			}
        }
    }

    public void stateChanged(ChangeEvent e) {
    }

 
    /**
	 * @param args	The command line arguments.
	 */
	public static void main( String args[] ) {
		new myComponentOptionPanel( new JFrame() , true, new myComponent(-1) ).show();
		
	}
 
    /**
     * Returns the value of Input 1.
     *
     * @return String	Value of Input 1.
     */    
    public String getNameField() {
		String value = null;
		if (nameField.getText() != null) {
			value = nameField.getText().trim();
		}	
    	return value;
    }
    public String getEquationsField() {
		String value = null;
		if (equationsField.getText() != null) {
			value = equationsField.getText();
		}	
    	return value;
    }

 	public Color getColorField() {
		Color value = null;
		if (color != null) {
			value = color;
		}	
    	return value;
    }

    /**
     * Returns the response from the dialog box.
     *
     * @return String	Response string for dialog box.
	 *					equals "OK" if user hits OK.
	 *                  equals null if user cancels.
     */    
    public String getResponse() {
    	return response;
    }
 
    /**
	 * Action listener to listen to the buttons.
	 */
    class ButtonListener implements ActionListener {
        public void actionPerformed( ActionEvent e ) {
        	if ( e.getActionCommand().equals( "OK" ) ) {
                response = "OK";  
            	hide();
        	} else if ( e.getActionCommand().equals( "Cancel" ) ) {
                response = null;  
            	hide();
        	}
        }
    }
}
