import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.ArrayList;

public class myComponent {

         // A class representing components that can be displayed on a guicCanvas.
         // When a component is first constructed, it has height and width zero
         // and a default color of white. It has one input and one output variable and no equations.
	  
	  int id;	
      int left, top;      // Position of top left corner of rectangle that bounds this shape.
      int width, height;  // Size of the bounding rectangle.
      Color color = Color.gray;  // Color of this shape.
	  String name;
	  String equations;
	  ArrayList variables = new ArrayList();; // The variables in the componant
	  
	  public myComponent(int ID){
	  	id = ID;
	  	equations="";
	  }
	  
      void reshape(int leftin, int topin, int widthin, int heightin) {
            // Set the position and size of this shape.
         this.left = leftin;
         this.top = topin;
         this.width = widthin;
         this.height = heightin;
      }
      
      void setSize(int width, int height) {
            // Set the size of this shape
         this.width = width+20;
         this.height = height+5;
      }
      
      int getLeft(){
      	return this.left;
      }
      int getTop(){
      	return this.top;
      }
      int getWidth(){
      	return this.width;
      }
      int getHeight(){
      	return this.height;
      }
      public void setColor(Color c){
      	this.color = c;
      }
      public Color getColor(){
      	return this.color;
      }
      String getName(){
      	return this.name;
      }
      void setName(String n){
      	this.name = n;
      }
      String getEquations(){
      	if(this.equations == null){
      		return "";
      	}
      	else{
      		return this.equations;
      	}
      }
      void setEquations(String e){
      	this.equations = e;
      }
      int getID(){
      	return this.id;
      }
      void setID(int idin){
      	this.id = idin;
      }
      ArrayList getVariables(){
      	return this.variables;
      }

      void moveBy(int dx, int dy) {
             // Move the shape by dx pixels horizontally and dy pixels vertically
             // (by changing the position of the top-left corner of the shape).
         left += dx;
         top += dy;
      }


      boolean containsPoint(int x, int y) {
            // Check whether the shape contains the point (x,y).
            // By default, this just checks whether (x,y) is inside the
            // rectangle that bounds the shape.  This method should be
            // overridden by a subclass if the default behavior is not
            // appropriate for the subclass.
         if (x >= left && x < left+width && y >= top && y < top+height)
            return true;
         else
            return false;
      }
      
      boolean containsResizePoint(int x, int y) {
         if (x >= left+width-5 && x < left+width && y >= top+height-5 && y < top+height)
            return true;
         else
            return false;
      }
      
      int[] variableAtPoint(int x, int y){
      	int[] varROW = {-1,-1};
  	  	
  	  	if(x>=left && x<left+(width/3)){ //Then it is an "in" variable
      		try{
      			varROW[0] = 1;
      			varROW[1] = (y-top) / (height/this.numVarIn());
      		}catch(Exception e){}
      	}
      	else if(x>=left+(width/3)*2 && x<left+width){ //Then it is an "out" variable
      		try{
      			varROW[0] = 3;
      			varROW[1] = (y-top) / (height/this.numVarOut());
      		}catch(Exception e){}
      	}
      	else{		
      		try{
      			varROW[0] = 2;
      			varROW[1] = (y-top) / (height/this.numVarMid());
      		}catch(Exception e){}

      	}
      	return varROW; 	
      }
      int variableIDfromColRow(int col, int row){
      	int rowCount = -1;
      	for (int i=0; i<variables.size(); i++){
         	Variable temp = (Variable)variables.get(i);
         	if (temp.getPub().equals("in") && col == 1){
         		rowCount++;
         	}
         	else if (temp.getPub().equals("out") && col == 3){
         		rowCount++;       		
         	}
         	else if (temp.getPub().equals("") && col == 2){
         		rowCount++;   		
         	}
     		
     		if (rowCount == row){
         		return temp.getID();
         	}
      	}
      	return -1;
      }
      Variable variableFromColRow(int col, int row){
      	int rowCount = -1;
      	for (int i=0; i<variables.size(); i++){
         	Variable temp = (Variable)variables.get(i);
         	if (temp.getPub().equals("in") && col == 1){
         		rowCount++;
         	}
         	else if (temp.getPub().equals("out") && col == 3){
         		rowCount++;       		
         	}
         	else if (temp.getPub().equals("") && col == 2){
         		rowCount++;   		
         	}
     		
     		if (rowCount == row){
         		return temp;
         	}
      	}
      	return new Variable(-1, -1);     	
      }
      
      Variable variableByName(String varName){
      	for (int i=0; i<variables.size(); i++){
         	Variable temp = (Variable)variables.get(i);
         	if (temp.getName().equals(varName)){
         		return temp;
         	}
      	}
      	return null;
      }
      
      void addVariable(Variable v){
      	variables.add(v);
      	int row = 0;
      	if (v.getPub().equals("in")){
      		row = this.numVarIn();
      	}
      	else if(v.getPub().equals("out")){
      		row = this.numVarOut();
      	}
      	else{
      		row = (this.numVarMid());
      	}
      	v.setCRow(row-1);
      }
      
      void deleteVariable(int idin){
      	for (int i=0; i<variables.size(); i++){
      		Variable temp = (Variable)variables.get(i);
      		if (temp.getID() == idin){
      			variables.remove(i);
      			break;
      		}
      	}
      	updateVariableRows();
      }
      
      void updateVariableRows(){
      	int numIn = 0;
      	int numMid = 0;
      	int numOut = 0;
      	int row = 0;
      	
      	for (int i=0; i<variables.size(); i++){
      		Variable v = (Variable)variables.get(i);
	      	if (v.getPub().equals("in")){
	      		row = numIn;
	      		numIn++;
	      	}
	      	else if(v.getPub().equals("out")){
	      		row = numOut;
	      		numOut++;
	      	}
	      	else{
	      		row = numMid;
	      		numMid++;
	      	}
	      	v.setCRow(row);
      	}
      }
      
      void draw(Graphics g) {
         g.setColor(color);
         g.fillRect(left,top,width,height);
         g.setColor(Color.black);
         g.drawRect(left,top,width,height);
         
         Font font = new Font("Serif", Font.PLAIN, 12);
         g.setFont(font);
         g.drawString(name, left, top-1);
         
     
         int vsize = variables.size();
         int leftx = 0;
         int lefty = 0;
         int vheight = 0;
         int numIn = 0;
         int numOut = 0;
         int numMid = 0;
         for (int i=0; i<vsize; i++){
         	int vwidth = (width-4)/3;
         	Variable temp = (Variable)variables.get(i);
         	if (temp.getPub().equals("in")){
         		leftx = left+ 2;
         		lefty = top+((height-4)/this.numVarIn())*temp.getCRow() + 2;
         		vheight = ((height-4)/this.numVarIn());
         		numIn++;
         	}
         	else if(temp.getPub().equals("out")){
         		leftx = left + ((width-4)/3)*2 + 2;
         		lefty = top+((height-4)/this.numVarOut())*temp.getCRow() + 2;
         		vheight = ((height-4)/this.numVarOut());
         		numOut++;        		
         	}
         	else{
         		leftx = left + ((width-4)/3) + 2;
         		lefty = top+((height-4)/(this.numVarMid()))*temp.getCRow() + 2;
         		vheight = ((height-4)/(this.numVarMid()));
         		numMid++;        		
         	}
         	g.setColor(temp.getColor());     	
     		g.fillRect(leftx, lefty, vwidth, vheight);
     		g.setColor(Color.black);
     		g.drawRect(leftx, lefty, vwidth, vheight);	
         }
         

  
      }
      
      void showAll(){
      	System.out.println(this.name);
      	for (int i=0; i< variables.size(); i++){
         	Variable temp = (Variable)variables.get(i);
         	System.out.println(temp.getName());
      	}
      	
      }
      
      int numVarIn(){
      	int numIn = 0;
      	for (int i=0; i<variables.size(); i++){
        	Variable temp = (Variable)variables.get(i);
      		if (temp.getPub().equals("in")){ numIn++; }
      	}
      	return numIn;
      }
      int numVarOut(){
      	int numOut = 0;
      	for (int i=0; i<variables.size(); i++){
        	Variable temp = (Variable)variables.get(i);
      		if (temp.getPub().equals("out")){ numOut++; }
      	}
      	return numOut;
      }
      int numVarMid(){
      	int numMid = 0;
      	for (int i=0; i<variables.size(); i++){
        	Variable temp = (Variable)variables.get(i);
      		if (temp.getPub().equals("")){ numMid++; }
      	}
      	return numMid;
      }

   }  // end of class Component