//A Java program aimed at graphically representing and creating CellML models
//Written by David Cumin
//Last updated on 16 March 2008 by David Cumin

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import java.util.ArrayList;
import java.util.*;

import java.io.*;

import org.w3c.dom.Document;
import org.w3c.dom.*;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException; 

public class guicellml extends JFrame {

   public static void main(String[] args) {
        // Create a new file
      	new guicellml();	
   }

   JScrollPane Scroll;
   JPopupMenu popup;
   JPopupMenu vStartpopup;
   JPopupMenu vEndpopup;
   JPopupMenu vMidpopup;
   int cIDcount = 0;
   int vIDcount = 0;
 
 public guicellml() {  
       // The constructor.  Set up the frmae's GUI, and show the frame.
      // The frame contains a canvas, or drawing area, and a menu bar.
      // The pop-up menu is also created in this constructor.
        
      super("guicellml v1.0");  // Title of window
   
      /* Create the "canvas" which displays the shapes and serves as
         the content pane of the frame. */
      
      guicCanvas canvas = new guicCanvas();
      Scroll = new JScrollPane( canvas, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS );
	  setContentPane(Scroll);
            
      /* Create the menu bar and the menus */
      
      JMenuBar menubar = new JMenuBar();
      setJMenuBar(menubar);
      
      JMenu fileMenu = new JMenu("File");
      fileMenu.setMnemonic('F');
      menubar.add(fileMenu);
      
      JMenu modelMenu = new JMenu("Model");
      modelMenu.setMnemonic('M');
      menubar.add(modelMenu);


      /* Create menu items for adding shapes to the canvas,
         and add them to the "Add" menu.  The canvas serves
         as ActionListener for these menu items. */      
      
      JMenuItem comp = new JMenuItem("Add Component");
      comp.setAccelerator( KeyStroke.getKeyStroke("ctrl N") );
      modelMenu.add(comp);
      comp.addActionListener(canvas);
      JMenuItem varb = new JMenuItem("Add Variable");
      varb.setAccelerator( KeyStroke.getKeyStroke("ctrl M") );
      modelMenu.add(varb);
      varb.addActionListener(canvas);
      JMenuItem units = new JMenuItem("Units");
      units.setAccelerator( KeyStroke.getKeyStroke("ctrl U") );
      modelMenu.add(units);
      units.addActionListener(canvas);
      
      
      /* Create the "Clear" menu item, and add it to the
         "Options" menu.  The canvas will listen for events
         from this menu item. */

      JMenuItem clear = new JMenuItem("Clear");
      clear.setAccelerator( KeyStroke.getKeyStroke("ctrl C") );
      clear.addActionListener(canvas);
      fileMenu.add(clear);
      JMenuItem save = new JMenuItem("Save");
      save.setAccelerator( KeyStroke.getKeyStroke("ctrl S") );
      save.addActionListener(canvas);
      fileMenu.add(save);
      JMenuItem load = new JMenuItem("Load");
      load.addActionListener(canvas);
      fileMenu.add(load);
      
      JMenuItem corCode = new JMenuItem("Write COR");
      corCode.addActionListener(canvas);
      modelMenu.add(corCode);

      /* Create the pop-up menu and add commands for editing a
         shape.  This menu is not used until the user performs
         the pop-up trigger mouse gesture on a shape. */
         
      popup = new JPopupMenu();
      popup.add("Add Variable").addActionListener(canvas);
      popup.add("Edit Component").addActionListener(canvas);
      popup.add("Delete Component").addActionListener(canvas);
      popup.add("Bring to Front").addActionListener(canvas);
      popup.addSeparator();
      
      vStartpopup = new JPopupMenu();
      vStartpopup.add("Add Variable").addActionListener(canvas);
      vStartpopup.add("Edit Component").addActionListener(canvas);
      vStartpopup.add("Delete Component").addActionListener(canvas);
      vStartpopup.add("Bring to Front").addActionListener(canvas);
      vStartpopup.addSeparator();
      vStartpopup.add("Edit Variable").addActionListener(canvas);
      vStartpopup.add("Delete Variable").addActionListener(canvas);
      vStartpopup.add("Set Join Start").addActionListener(canvas);
      
      vEndpopup = new JPopupMenu();
      vEndpopup.add("Add Variable").addActionListener(canvas);
      vEndpopup.add("Edit Component").addActionListener(canvas);
      vEndpopup.add("Delete Component").addActionListener(canvas);
      vEndpopup.add("Bring to Front").addActionListener(canvas);
      vEndpopup.addSeparator();
      vEndpopup.add("Edit Variable").addActionListener(canvas);
      vEndpopup.add("Delete Variable").addActionListener(canvas);
      vEndpopup.add("Set Join End").addActionListener(canvas);
	  
	  vMidpopup = new JPopupMenu();
      vMidpopup.add("Add Variable").addActionListener(canvas);
      vMidpopup.add("Edit Component").addActionListener(canvas);
      vMidpopup.add("Delete Component").addActionListener(canvas);
      vMidpopup.add("Bring to Front").addActionListener(canvas);
      vMidpopup.addSeparator();
      vMidpopup.add("Edit Variable").addActionListener(canvas);
      vMidpopup.add("Delete Variable").addActionListener(canvas);
      	
      
      /* Set the "DefaultCloseOperation" for the frame.  This determines
         what happens when the user clicks the close box of the frame.
         It is set here so that System.exit() will be called to end
         the program when the user closes the window. */
         
      setDefaultCloseOperation(EXIT_ON_CLOSE);
      
      /* Set the size and location of the frame, and make it visible. */
      
      setLocation(20,50);
      setSize(550,420);
      show();
      
      
      
      //new Save("yo yo yo", "testing/aaa.txtt");
      
   } // end constructor
      
   
   //---- Nested class definitions ---
   //
   // The remainder of the guicellml class consists of static nested class definitions.
   // These are just like regular classes, except that they are defined inside
   // another class (and hence have full names, when used outside this class, such
   // as guicellml.guicCanvas).

   class guicCanvas extends JPanel
                     implements ActionListener, MouseListener, MouseMotionListener {

         // This class represents a "canvas" that can display colored shapes and
         // let the user drag them around.  It uses an off-screen images to 
         // make the dragging look as smooth as possible.

      ArrayList components = new ArrayList(); 
           // holds a list of the shapes that are displayed on the canvas
	  ArrayList componentFulls = new ArrayList();
	  ArrayList joins = new ArrayList();
	  ArrayList units = new ArrayList();
	 
	  myComponent currentJoinStartc = null;
	  Variable currentJoinStartv = null;
	  myComponent currentJoinEndc = null;
	  Variable currentJoinEndv = null;
	  
	  int px;
	  int py;
	  	
      guicCanvas() {
           // Constructor: set background color to white 
           // set up listeners to respond to mouse actions
         setBackground(Color.white);
         addMouseListener(this);
         addMouseMotionListener(this);
      }   

      public void paintComponent(Graphics g) {
           // In the paint method, all the shapes in ArrayList are
           // copied onto the canvas.
         super.paintComponent(g);  // First, fill with background color.
         int comps = components.size();
         for (int i = 0; i < comps; i++) {
            myComponent c = (myComponent)components.get(i);
            c.draw(g);
            if(c == clickedComp){
            	g.setColor(Color.blue);
            	g.drawRect(c.getLeft()-1, c.getTop()-1, c.getWidth()+2, c.getHeight()+2);
            }
         }
         int jns = joins.size();
         for (int i = 0; i < jns; i++) {
            Join j = (Join)joins.get(i);
            j.draw(g);
         }

      }   

      public void actionPerformed(ActionEvent evt) {
             // Called to respond to action events from the
             // menus or pop-up menu.
         String command = evt.getActionCommand();
         if (command.equals("Clear")) {
            components.clear(); // Remove all items from the ArrayList
            joins.clear();
            cIDcount = 0;
            vIDcount = 0;
            repaint();
         }
         else if (command.equals("Add Component")){
            addComponent();     
         }
         else if(command.equals("Units")){
         	UnitsPanel md = new UnitsPanel(new JFrame(), true, units);
	        md.setLocation(200,200);
			md.setVisible( true );
	
			if (md.getResponse().equals("OK")) {
			    units = md.getUnits();
			    md.dispose();
			} else {
			    md.dispose();
			} 		
         }                 
         else if (clickedComp != null) {
                
            if (command.equals("Delete Component")){
            	components.remove(clickedComp);
            	for(int i=0; i<joins.size(); i++){
                	Join temp = (Join)joins.get(i);
                	int[] IDs = temp.getVarIDS();
                	if((IDs[0] == clickedComp.getID()) || (IDs[1] == clickedComp.getID())){
                		joins.remove(i);
                	}
                }
            }
            else if (command.equals("Edit Component")) {
            	myComponentOptionPanel md = new myComponentOptionPanel(null, true, clickedComp);
                md.setLocation(px+10, py+10);
	  			md.setVisible( true );
				if (md.getResponse().equals("OK")) {
				    clickedComp.setName(md.getNameField());
				    clickedComp.setColor(md.getColorField());
				    clickedComp.setEquations(md.getEquationsField());
				    md.dispose();
				} else {
				    md.dispose();
				}   
            }
            else if (command.equals("Bring to Front")) {
               if(clickedComp != null){
               		components.remove(clickedComp);
               		components.add(clickedComp);  
               }
               else{
               }
               	
            }
            else if (command.equals("Set Join Start")) {
            	if(clickedComp != null){
	                currentJoinStartc = clickedComp;
	                int[] var = clickedComp.variableAtPoint(px,py);
	                currentJoinStartv = clickedComp.variableFromColRow(var[0],var[1]);
            	}
                else{
                }
            }
            else if (command.equals("Set Join End")) {
                if(clickedComp != null){
                	currentJoinEndc = clickedComp;
                	int[] var = clickedComp.variableAtPoint(px,py);
                	currentJoinEndv = clickedComp.variableFromColRow(var[0],var[1]);
                }
                else{
                }
            }
            else if (command.equals("Add Variable") || command.equals("Variable")) {
                if(clickedComp != null){
                	addVariableToComponent(clickedComp);
                }
                else{
                	JOptionPane.showMessageDialog(null,"There is no component selected!", "Error", 
                														JOptionPane.WARNING_MESSAGE);
                }
            }
            else if (command.equals("Edit Variable")) {
                 if(clickedComp != null){
                 	editVariable();
                 }
                 else{
                 }
            }
            else if (command.equals("Delete Variable")) {
            	if(clickedComp != null){
                 	int[] var = clickedComp.variableAtPoint(px,py);
                	int varID = clickedComp.variableIDfromColRow(var[0], var[1]);
	                clickedComp.deleteVariable(varID);
	                //delete any joins too
	                for(int i=0; i<joins.size(); i++){
	                	Join temp = (Join)joins.get(i);
	                	int[] IDs = temp.getVarIDS();
	                	if((IDs[2] == varID) || (IDs[3] == varID)){
	                		joins.remove(i);
	                	}
	                }
            	 }
            	 else{
            	 } 
            }
        }
        if (command.equals("Write COR")) {
        	writeCOR();
        }
        else if (command.equals("Save")) {
        	File file = getFile("Save");
        	new Save(saveXMLString(), file);
        }
        else if (command.equals("Load")) {
        	File file = getFile("Load");
        	Load(file);
        }
        
		if (currentJoinStartv != null && currentJoinEndv != null){
            addJoin(new Join(currentJoinStartc, currentJoinStartv, currentJoinEndc, currentJoinEndv));
            currentJoinStartv = null;
            currentJoinEndv = null;	
        }  
        repaint();
      } // end actionPerformed()
      
      File getFile(String function){
      	JFileChooser fc = new JFileChooser();
      	fc.setApproveButtonText(function);
      	fc.setDialogTitle(function);
      	int returnVal = fc.showDialog(this, function);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile();
            //This is where a real application would save the file.
            return file;
        } else {
            return null;
        }      	
      }
      
      void editVariable(){
      	int[] var = clickedComp.variableAtPoint(px,py);
        Variable v = clickedComp.variableFromColRow(var[0],var[1]);            
        
        VariableOptionPanel md = new VariableOptionPanel(null, true, v);
        md.setLocation(px+10, py+10);
		md.setVisible( true );
		if (md.getResponse().equals("OK")) {
		    v.setName(md.getNameField());
		    if( !(md.getInitField()== null) ){
			    	v.setInit(Double.parseDouble(md.getInitField()));	
			}
		    v.setUnits(md.getUnitField());
		    v.setPub(md.getPubBox());
		    v.setColor(md.getColorField());
		    clickedComp.updateVariableRows();
		    md.dispose();
		} else {
		    md.dispose();
		}
      }
      
	  void writeCOR(){
	  	String CORString = "";
	  	int comps = components.size();
     	CORString += ("def model MODEL as\n");
     		
        for (int i = 0; i < comps; i++) {
            myComponent c = (myComponent)components.get(i);
            CORString += ("def comp " + c.getName() + " as\n");	            
            ArrayList vars = c.getVariables();
            for (int j=0; j<vars.size(); j++){
            	Variable v = (Variable)vars.get(j);
            	CORString += ("var " + v.getName()+": ");
            	CORString += (v.getUnits() + " " );
           		if (v.getInit() == null){
            		CORString += ("{");
            	}
            	else{
            		CORString += ("{init: " + v.getInit());		
            	}
            	if (v.getPub().equals("")){
            		CORString += ("};");
            	}
            	else{
            		if(v.getInit() != null){
            			CORString += (",");
            		}
            		CORString += (" pub: " + v.getPub() + "};");
            	}
            	CORString += ("\n");
            }

            CORString += (c.getEquations() + "\n");
           
           	CORString += ("enddef;\n"); 
        }
        CORString += (corFromJoins() + "\n");
        CORString += (corFromUnits() + "\n");        
        
        CORString += ("enddef;\n"); 
        
        
        JTextArea corField = new JTextArea(CORString);
		corField.setLineWrap(true);
        corField.setWrapStyleWord(true);
		JScrollPane corScroll = new JScrollPane( corField, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS );
		JFrame corFrame = new JFrame("COR code");
		corFrame.getContentPane().add(corScroll);
		corFrame.setBounds(50,50,550,550);
        corFrame.show(true);
        
	  }
	  
	  String saveXMLString(){
	  	
	  	String SaveString = "";
	  	int comps = components.size();
     	
     	SaveString += "<guiCellMLFile-v0>\n";
        for (int i = 0; i < comps; i++) {
            myComponent c = (myComponent)components.get(i);
            
            SaveString += "<component";          
            SaveString += (" name=\"" + c.getName() + "\"");
            SaveString += (" guileft=\"" + c.getLeft() + " \"");
            SaveString += (" guitop=\"" + c.getTop() + " \"");
            SaveString += (" guiwidth=\"" + c.getWidth() + " \"");
            SaveString += (" guiheight=\"" + c.getHeight() +  " \"");
            SaveString += (" guicolor=\"" + (c.getColor().getRed()+","+
            							c.getColor().getGreen()+","+
            							c.getColor().getBlue()) + 
            							" \">\n");
            
            //Variables            
            ArrayList vars = c.getVariables();
            for (int j=0; j<vars.size(); j++){
            	SaveString += " \t<variable ";
            	Variable v = (Variable)vars.get(j);
            	SaveString += (" name=\"" + v.getName() + " \"");
            	SaveString += (" units=\"" + v.getUnits() +  " \"");
            	if(v.getInit() == null){
            		SaveString += ("");
            	}
            	else{
            		SaveString += (" initial_value=\"" + v.getInit() + " \"");
            	}
            	SaveString += (" public_interface=\"" + v.getPub() + " \"");
            	SaveString += (" guicolor=\"" + (v.getColor().getRed()+","+
            							v.getColor().getGreen()+","+
            							v.getColor().getBlue()) + 
            							" \"");
            	SaveString += "/>\n";
          	}
          	
          	SaveString += "<math><!--\n";
            SaveString += (c.getEquations() + "\n");
           	SaveString += "--></math>\n";
           	
           	SaveString += "</component>\n"; 
        }
        //Save Joins too
        int numjoins = joins.size();
        if (numjoins > 0){
	        
	        String[][] allJoins = new String[numjoins][4];
	        //build up the array
	        for (int n=0; n<numjoins; n++){
		        Join join = (Join)joins.get(n);
		        allJoins[n][0] = join.getFromc().getName();
		        allJoins[n][1] = join.getToc().getName();
		        allJoins[n][2] = join.getFromv().getName();
		        allJoins[n][3] = join.getTov().getName();
		  	}
		        //Make the fromc the lowest one
        	for(int i=0; i<numjoins; i++){
        		if(allJoins[i][0].compareTo(allJoins[i][1]) > 0){
	        		String temp = allJoins[i][0];
	        		allJoins[i][0] = allJoins[i][1];
	        		allJoins[i][1] = temp;
	        		//change the variables to match the components too
	        		temp = allJoins[i][2];
	        		allJoins[i][2] = allJoins[i][3];
	        		allJoins[i][3] = temp;
        		}
       		}
       		//Order the joins
       		Arrays.sort(allJoins,new LastFirstComparator());
       		
       		//Print the first one
       		SaveString += "<connection>\n";
       		SaveString += ("<map_components component_1=\"" + allJoins[0][0] + 
       								  "\" component_2=\"" + allJoins[0][1] + "\"/>\n"); 
       		SaveString += ("<map_variables variable_1=\"" + allJoins[0][2] + 
       								 "\" variable_2=\"" + allJoins[0][3] + "\"/>\n");      	
      		
      		String compsKey = allJoins[0][0] + "-" + allJoins[0][1];   
       		for(int i=1; i<numjoins; i++){  				
		    	if (compsKey.equals(allJoins[i][0] + "-" + allJoins[i][1])){ //If it's the same components
		    		SaveString += ("<variables variable_1=\"" + allJoins[i][2] + 
		    								 "\" variable_2=\"" + allJoins[i][3] + "\"/>\n");	
		    	}
		    	else{
		    		SaveString += "</connection>\n<connection>\n";
		    		SaveString += ("<map_components component_1=\"" + allJoins[i][0] + 
       								 		  "\" component_2=\"" + allJoins[i][1] + "\"/>\n"); 
       				SaveString += ("<map_variables variable_1=\"" + allJoins[i][2] + 
       								 		 "\" variable_2=\"" + allJoins[i][3] + "\"/>\n");	
		    	}			    
			   	compsKey = allJoins[i][0] + "-" + allJoins[i][1]; 
	         }
	         SaveString += "</connection>\n";
        }
        //Save the units            
        for (int u=0; u<units.size(); u++){
        	Unit unit = (Unit)units.get(u);
        	SaveString += "<units ";      	
        	SaveString += (" name=\"" + unit.getName() + " \">");
 			ArrayList subUnits = unit.getSubUnits();
 			for(int su=0; su<subUnits.size(); su++){
 				Unit temps = (Unit)subUnits.get(su);
 				SaveString += ("<unit units=\"" + temps.getName());
 				if(!temps.isBare()){
	        		SaveString += "\" ";
	        		if(!temps.getPref().equals("")){
	        			SaveString += ("prefix=\"" + temps.getPref() + "\"");
	        		}
	        		if(temps.getExpo() != 0.0){
	        			if(!temps.getPref().equals("")) SaveString += "";
	        			SaveString += ("exponent=\"" + temps.getExpo() + "\"");
	        		}
	        		if(temps.getMult() != 1.0){
	        			if(!temps.getPref().equals("") || temps.getExpo() != 0.0) SaveString += "";
	        			SaveString += ("multiplyer=\"" + temps.getMult()+ "\"");
	        		}
	        		if(temps.getOffset() != 0.0){
	        			if(!temps.getPref().equals("") || temps.getExpo() != 0.0 || temps.getMult() != 1.0) SaveString += "";
	        			SaveString += ("offset=\"" + temps.getOffset()+ "\"");
	        		}
	        		SaveString += "/>\n";
        		}
        		else{
        			SaveString += "\"/>\n";
        		}
 			}
        	SaveString += "</units>\n";
      	}
      	

        //END TAG
        SaveString += "</guiCellMLFile-v0>\n";
        return SaveString;
               	  	
	  }
	  
	  void addVariableToComponent(myComponent c){
	  	Variable v = new Variable(vIDcount, c.getID());
	  	VariableOptionPanel md = new VariableOptionPanel(null, true, v);
	  	md.setLocation(px+10, py+10);
	  	md.setVisible( true );
				if (md.getResponse().equals("OK")) {
				    v.setName(md.getNameField());
				    if( !(md.getInitField()== null) ){
			    		v.setInit(Double.parseDouble(md.getInitField()));	
			    	}				   
			    	v.setUnits(md.getUnitField());
			    	v.setPub(md.getPubBox());
				    v.setColor(md.getColorField());
				    clickedComp.updateVariableRows();
				    md.dispose();
				} else {
				    md.dispose();
				}
	  	c.addVariable(v);
	  	vIDcount++;
	  	
	  }
	  
      void addComponent() {
             // Add the shape to the canvas, and set its size, color
             // and whether or not it should have a black border.  These
             // properties are determined by looking at the states of 
             // various menu items.  The shape is added at the top-left 
             // corner of the canvas.
         myComponent component = new myComponent(cIDcount);
         component.setColor(Color.gray);
         component.reshape(3,3,100,60);  
         components.add(component);
         component.setName("C" + components.size());
         cIDcount++;
         
         repaint();
      } // end addShape()

      
	  void addJoin(Join join) {             
         joins.add(join);      
         repaint();
      } // end addShape()
      
      void addUnit(Unit unit){
      	units.add(unit);
      }

  	  public myComponent getComponentMouse(int x, int y){
  	  	myComponent s = null;
  	  	for ( int i = components.size() - 1; i >= 0; i-- ) {  
            myComponent temp = (myComponent)components.get(i);
            if (temp.containsPoint(x,y)) {
               	s = temp;
               	break;
            }
         }
         return s;
  	  }
  	   public myComponent getComponentResizeMouse(int x, int y){
  	  	myComponent s = null;
  	  	for ( int i = components.size() - 1; i >= 0; i-- ) {  
            myComponent temp = (myComponent)components.get(i);
            if (temp.containsResizePoint(x,y)) {
               	s = temp;
               	break;
            }
         }
         return s;
  	  }
  	  
  	  String corFromUnits(){
  	  	//Print out all the units and their subunits
        String CORunitString = "";
        for(int i=0; i<units.size(); i++){
        	Unit temp = (Unit)units.get(i);
        	
        	CORunitString += ("def unit "  + temp.getName() + " from\n");
        	for(int j=0; j<temp.getSubUnits().size(); j++){
        		Unit temps = (Unit)temp.getSubUnits().get(j);
        		CORunitString += ("unit " + temps.getName());
        		if(!temps.isBare()){
	        		CORunitString += " {";
	        		if(!temps.getPref().equals("")){
	        			CORunitString += ("pref: " + temps.getPref());
	        		}
	        		if(temps.getExpo() != 0.0){
	        			if(!temps.getPref().equals("")) CORunitString += ", ";
	        			CORunitString += ("expo: " + temps.getExpo());
	        		}
	        		if(temps.getMult() != 1.0){
	        			if(!temps.getPref().equals("") || temps.getExpo() != 0.0) CORunitString += ", ";
	        			CORunitString += ("mult: " + temps.getMult());
	        		}
	        		if(temps.getOffset() != 0.0){
	        			if(!temps.getPref().equals("") || temps.getExpo() != 0.0 || temps.getMult() != 1.0) CORunitString += ", ";
	        			CORunitString += ("offset: " + temps.getOffset());
	        		}
	        		CORunitString += "};\n";
        		}
        		else{
        			CORunitString += ";\n";
        		}
        	}
        	CORunitString += ("enddef;\n");
        }
        return CORunitString;
  	  }
  	  
  	  String corFromJoins(){
  	  		String corJoins = "";
  	  		//Put the names into a string array
  	  		int numjoins = joins.size();
	        if (numjoins > 0){
		        
		        String[][] allJoins = new String[numjoins][4];
		        //build up the array
		        for (int n=0; n<numjoins; n++){
			        Join join = (Join)joins.get(n);
			        allJoins[n][0] = join.getFromc().getName();
			        allJoins[n][1] = join.getToc().getName();
			        allJoins[n][2] = join.getFromv().getName();
			        allJoins[n][3] = join.getTov().getName();
			  	}
			        //Make the fromc the lowest one
	        	for(int i=0; i<numjoins; i++){
	        		if(allJoins[i][0].compareTo(allJoins[i][1]) > 0){
		        		String temp = allJoins[i][0];
		        		allJoins[i][0] = allJoins[i][1];
		        		allJoins[i][1] = temp;
		        		//change the variables to match the components too
		        		temp = allJoins[i][2];
		        		allJoins[i][2] = allJoins[i][3];
		        		allJoins[i][3] = temp;
	        		}
	       		}
	       		//Order the joins
	       		Arrays.sort(allJoins,new LastFirstComparator());
	       		
	       		//Print the first one
	       		String comps = allJoins[0][0] + "-" + allJoins[0][1];
	       		corJoins += ("def map between " + allJoins[0][0]);
			    corJoins += (" and " + allJoins[0][1] + " for\n");
			    corJoins += ("vars " + allJoins[0][2]);
				corJoins += (" and " + allJoins[0][3] + ";\n");
		    
	       		for(int i=1; i<numjoins; i++){  				
			    	if (comps.equals(allJoins[i][0] + "-" + allJoins[i][1])){ //If it's the same components
			    		corJoins += ("vars " + allJoins[i][2]);
						corJoins += (" and " + allJoins[i][3] + ";\n");	
			    	}
			    	else{
			    		corJoins += ("enddef;\n");
			    		corJoins += ("def map between " + allJoins[i][0]);
			    		corJoins += (" and " + allJoins[i][1] + " for\n");
			    		corJoins += ("vars " + allJoins[i][2]);
						corJoins += (" and " + allJoins[i][3] + ";\n");	
			    	}			    
				    
				    comps = allJoins[i][0] + "-" + allJoins[i][1];
		         }
		         corJoins += ("enddef;\n"); 
	        }	         	
	         	
	         return corJoins;
  	  }
  	  
  	  
  	  void Load(File filein){
  	  	  	  	
  	  	try {
			int equationCount = 0;
			
	  	  	DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    	    DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
  	  		Document doc = docBuilder.parse(filein);
  	  		
  	  		//Get the components
  	  		NodeList listOfComponents = doc.getElementsByTagName("component");
  	  		for(int c=0; c<listOfComponents.getLength() ; c++){
  	  			
  	  			Node compNode = listOfComponents.item(c);
                if(compNode.getNodeType() == Node.ELEMENT_NODE){

                    Element compElement = (Element)compNode;
					//Get the name
                    String name = compElement.getAttribute("name").trim();
 //System.out.println("Name : " + name);
 					//Get the left
 					int left = cIDcount*20;
 					if(!compElement.getAttribute("guileft").trim().equals("")){
 						left = Integer.parseInt(compElement.getAttribute("guileft").trim());
 					}
 //System.out.println("left : " + left);
 					//Get the top
 					int top = cIDcount*20;
 					if(!compElement.getAttribute("guitop").trim().equals("")){
 						top = Integer.parseInt(compElement.getAttribute("guitop").trim());
 					}
 //System.out.println("top : " + top);
 					//Get the width
 					int width = 200;
 					if(!compElement.getAttribute("guiwidth").trim().equals("")){
 						width = Integer.parseInt(compElement.getAttribute("guiwidth").trim());
 					}
 //System.out.println("width : " + width);
					//Get the height
 					int height = 100;
 					if(!compElement.getAttribute("guiheight").trim().equals("")){
 						height = Integer.parseInt(compElement.getAttribute("guiheight").trim());
 					}
 //System.out.println("height : " + height);
 					//Get the colour
 					String colour = "100,100,100";
 					if(!compElement.getAttribute("guicolor").trim().equals("")){
 						colour = compElement.getAttribute("guicolor").trim();
 					}
 //System.out.println("colour : " + colour);
 					 
 					//ADD THE COMPONENT
 					addComponent();
 					myComponent com = (myComponent)components.get(cIDcount-1);
 					//Get the equations
					if(compElement.getElementsByTagName("math").getLength() > 0){
						equationCount ++;
						//System.out.println("comp for eq: " + name); 		
                		String equations = getEquationsFrom(filein, equationCount);
 //System.out.println("Equations : " + equations);
 						com.setEquations(equations);	
					}

 					com.setName(name);
 					com.reshape(left, top, width, height);
 					int red = colour.indexOf(",");
				    int green = colour.indexOf(",",red+1);
				    Color col = new Color(Integer.parseInt(colour.substring(0,red)), 
    						Integer.parseInt(colour.substring(red+1,green)), 
    						Integer.parseInt(colour.substring(green+1,colour.length())));
 					com.setColor(col);
 									
 					//Variables within the comp			
  	  				NodeList listOfVariables = compElement.getElementsByTagName("variable");
  	  				for(int v=0; v<listOfVariables.getLength() ; v++){ 	  			
 	  					Node varNode = listOfVariables.item(v);
                		if(varNode.getNodeType() == Node.ELEMENT_NODE){
                    		Element varElement = (Element)varNode;		  				
  	  				
	               			//get the name
	  	  					String vname = varElement.getAttribute("name").trim();
 //System.out.println("Name : " + vname);
 
 							//get the units
	  	  					String vunits = varElement.getAttribute("units").trim();
 //System.out.println("Units : " + vunits);
 							
 							//get the init
	  	  					Double vinit=null;
	  	  					if(!varElement.getAttribute("initial_value").trim().equals("")){
	  	  						vinit = Double.parseDouble(varElement.getAttribute("initial_value").trim());
	  	  					}                    	 
 //System.out.println("Init : " + vinit);

 							//get the pub
	  	  					String vpub = varElement.getAttribute("public_interface").trim();
 //System.out.println("Pub : " + vpub);
 
 							//get the colour
	  	  					String vcolour = "100,100,100";
 							if(!varElement.getAttribute("guicolor").trim().equals("")){
 								vcolour = varElement.getAttribute("guicolor").trim();
 							}
//System.out.println("Colour : " + vcolour);
 							
 							
 							//MAKE VARIABLE AND ADD IT TO COMPONENT
 							Variable var = new Variable(vIDcount, com.getID());
 							var.setName(vname);
 							var.setInit(vinit);
 							var.setUnits(vunits);
 							var.setPub(vpub);
 							int vred = vcolour.indexOf(",");
						    int vgreen = vcolour.indexOf(",",vred+1);
						    Color vcol = new Color(Integer.parseInt(vcolour.substring(0,vred)), 
					    						Integer.parseInt(vcolour.substring(vred+1,vgreen)), 
					    						Integer.parseInt(vcolour.substring(vgreen+1,vcolour.length())));
 							var.setColor(vcol);
 							vIDcount++;
 							com.addVariable(var);
                		}	
  	  				}
 
                    //------
                }

            }//end of component
            
            
            //NOW find and do joins
        	NodeList listOfJoins = doc.getElementsByTagName("connection");
  	  		for(int j=0; j<listOfJoins.getLength() ; j++){
  	  			
  	  			Node joinNode = listOfJoins.item(j);
                if(joinNode.getNodeType() == Node.ELEMENT_NODE){
                    Element joinElement = (Element)joinNode;
                    //get the components
  					NodeList cjList = joinElement.getElementsByTagName("map_components");
  					Element cjElement = (Element)cjList.item(0);
                	String cj1 = cjElement.getAttribute("component_1").trim();
                	String cj2 = cjElement.getAttribute("component_2").trim();
 //System.out.println("joins : " + cj1 + " , " + cj2);
                 	
                	NodeList cvList = joinElement.getElementsByTagName("map_variables");
                	for(int cv=0; cv<cvList.getLength(); cv++){
                		Element cvElement = (Element)cvList.item(cv);
                		String cv1 = cvElement.getAttribute("variable_1").trim();
                		String cv2 = cvElement.getAttribute("variable_2").trim();
 //System.out.println("vars : " + cv1 + " , " + cv2);
  
  					//FIND THE COMPONENTS
  					myComponent fromc = null;
  					Variable fromv = null;
  					myComponent toc = null;
  					Variable tov = null;
  					
  					for(int i=0; i<components.size(); i++){
  						myComponent tempc = (myComponent)components.get(i);
  						if(tempc.getName().equals(cj1)){
  							fromc = tempc;
  							for(int j1=0; j1<fromc.getVariables().size(); j1++){
  								Variable tempv1 = (Variable)fromc.getVariables().get(j1);
  								if(tempv1.getName().equals(cv1)){
  									fromv = tempv1;
  								}
  							}
  						}
  						//get the other variable
  						if(tempc.getName().equals(cj2)){
  							toc = tempc;
  							for(int j2=0; j2<toc.getVariables().size(); j2++){
  								Variable tempv2 = (Variable)toc.getVariables().get(j2);
  								if(tempv2.getName().equals(cv2)){
  									tov = tempv2;
  								}
  							}
  						}
  						//if the variables have been filled then check they are the right way around and break
  						if(fromv!=null && tov!=null){
  							if(tov.getPub().equals("out")){
  								myComponent tmpc = toc;
  								Variable tmpv = tov;
  								toc = fromc;
  								tov = fromv;
  								fromc = tmpc;
  								fromv = tmpv;
  							}
  							break;
  						}
  					}
  					Join temp = new Join(fromc, fromv, toc, tov);
  					addJoin(temp);	
                	}                   
                }
  	  		}
  	  		
  	  		
  	  		
        	//Now do Units
  	  		NodeList listOfUnits = doc.getElementsByTagName("units");
  	  		for(int u=0; u<listOfUnits.getLength(); u++){
  	  			
  	  			Node unitNode = listOfUnits.item(u);
                if(unitNode.getNodeType() == Node.ELEMENT_NODE){  		
                    Element unitElement = (Element)unitNode;
					//Get the name
                    String uname = unitElement.getAttribute("name").trim();
 //System.out.println("Name : " + uname);
 					
 					//MAKE THE UNIT
 					Unit nu = new Unit(uname);
 					
 					//get the properties of the units
 					NodeList subuList = unitElement.getElementsByTagName("unit");
                	for(int su=0; su<subuList.getLength(); su++){
                		Element subuElement = (Element)subuList.item(su);
                		String subName = subuElement.getAttribute("units").trim();
 //System.out.println("subName : " + subName);
 						String pref = subuElement.getAttribute("prefix");
 //System.out.println("pref : " + pref); 
 						Double expo = 0.0;
 						if(!subuElement.getAttribute("exponent").isEmpty()){
 							expo = Double.parseDouble(subuElement.getAttribute("exponent").trim());
 						}
 //System.out.println("expo : " + expo); 						
 						Double mult = 1.0;
 						if(!subuElement.getAttribute("multiplyer").isEmpty()){
 							mult = Double.parseDouble(subuElement.getAttribute("multiplyer").trim());
 						}
 //System.out.println("mult : " + mult);
 						Double offset = 0.0;
 						if(!subuElement.getAttribute("offset").isEmpty()){
 							offset = Double.parseDouble(subuElement.getAttribute("offset").trim());
 						}
 //System.out.println("offset : " + offset);
 						
 						//ADD THE SUBUNIT
 						Unit nsu = new Unit(subName, pref, expo, mult, offset);
 						nu.addSubUnit(nsu);               		
                	}
                	
                	//Add the unit to the units array
                	units.add(nu);
 
                }
  	  		}
  	
  	  	}
  	  	catch (SAXParseException err) {
  	  		String errorString = "";
	        errorString += ("** Parsing error" + ", line " 
	             + err.getLineNumber () + ", uri " + err.getSystemId () + "\n");
	        errorString += (" " + err.getMessage ());
System.out.println(errorString);
	        JOptionPane.showMessageDialog(new JFrame(), errorString);
        }
        catch (SAXException e) {
	        Exception x = e.getException ();
	        ((x == null) ? e : x).printStackTrace ();
        }
        catch (Throwable t) {
        	t.printStackTrace ();
        }
        
        Scroll.revalidate();
  	  	
  	  }
  	  
  	  String getEquationsFrom(File filein, int nth){
  	  	String equations = "";
  	  	
  	  	//Read in the entire file
  	  	StringBuffer contents = new StringBuffer();
    
	    try {
	      //use buffering, reading one line at a time
	      //FileReader always assumes default encoding is OK!
	      BufferedReader input =  new BufferedReader(new FileReader(filein));
	      try {
	        String line = null; //not declared within while loop
	        /*
	        * readLine is a bit quirky :
	        * it returns the content of a line MINUS the newline.
	        * it returns null only for the END of the stream.
	        * it returns an empty String if two newlines appear in a row.
	        */
	        while (( line = input.readLine()) != null){
	          contents.append(line);
	          contents.append(System.getProperty("line.separator"));
	        }
	      }
	      finally {
	        input.close();
	      }
	    }
	    catch (IOException ex){
	      ex.printStackTrace();
	    }
	    String all = contents.toString();
	    
	    //Find the 'nth' iteration of <Equaitons> and extract whatever is between the tags
	    int startTag = 0;
	    int endTag = 0;
	    for(int n=0; n<nth; n++){
	    	startTag = all.indexOf("<math",startTag+1);
	    	endTag = all.indexOf("</math>", endTag+1)	;
	    }
	    String commented = all.substring(startTag+6, startTag+10);
	    if(commented.equals("<!--")){ //it's obviously my worked around commented code
	    	equations = all.substring(startTag+10,endTag-3);
	    		System.out.println("plus 11 is " + commented);
	    			System.out.println("so eq is " + equations);
	    }
	    else{ //it might be real MML
	    	equations = all.substring(startTag+6,endTag);
	    }    
	    
//System.out.println("between " + startTag + " and " + endTag);
//System.out.println("eqs: " + equations);
		return equations;
  	  }



      
      myComponent clickedComp = null;  // This is the shape that the user clicks on.
                                  // It becomes the draggedComp is the user is
                                  // dragging, unless the user is invoking a
                                  // pop-up menu.  This variable is used in
                                  // actionPerformed() when a command from the
                                  // pop-up menu is processed.

      myComponent draggedComp = null;  // This is null unless a shape is being dragged.
                                  // A non-null value is used as a signal that dragging
                                  // is in progress, as well as indicating which shape
                                  // is being dragged. 
      myComponent resizeComp = null;                                                                            	                           

      int prevDragX;  // During dragging, these record the x and y coordinates of the
      int prevDragY;  // previous position of the mouse.
      
      public void mousePressed(MouseEvent evt) {
            // User has pressed the mouse.  Find the shape that the user has clicked on, if
            // any.  If there is no shape at the position when the mouse was clicked, then
            // ignore this event.  If there is then one of three things will happen:
            // If the event is a pop-up trigger, then the pop-up menu is displayed, and
            // the user can select from the pop-up menu to edit the shape.  If the user was 
            // holding down the shift key, then bring the clicked shape to the front, in 
            // front of all the other shapes.  Otherwise, start dragging the shape.
         if (draggedComp != null && resizeComp != null) {
              // A drag operation is already in progress, so ignore this click.
              // This might happen if the user clicks a second mouse button before
              // releasing the first one(?).
            return;
         }
         int x = evt.getX();  // x-coordinate of point where mouse was clicked
         int y = evt.getY();  // y-coordinate of point 
         clickedComp = null;  // This will be set to the clicked shape, if any.
         clickedComp = getComponentMouse(x, y);
                 	
         if (clickedComp == null) {
               // The user did not click on a shape.
            return;
         }
         else if (evt.isPopupTrigger()) {
              // The user wants to see the pop-up menu
            popup.show(this,x-10,y-2);
         }
         else if (evt.isShiftDown()) {
              // Bring the clicked shape to the front
            components.remove(clickedComp);
            components.add(clickedComp);
         }
         else if ((clickedComp.left+clickedComp.width>0) && (clickedComp.height+clickedComp.top>0)){
              // Start dragging the shape.
            draggedComp = clickedComp;
            prevDragX = x;
            prevDragY = y;
            
         }
         
         repaint();
      }

      public void mouseDragged(MouseEvent evt) {
      	 int x = evt.getX();
	     int y = evt.getY();
             // User has moved the mouse.  Move the dragged shape by the same amount.
         if (draggedComp == null) {
                // User did not click a shape.  There is nothing to do.
            return;
         }
         else if ((clickedComp.left+clickedComp.width>0) && (clickedComp.height+clickedComp.top>0)){
	         if(this.getCursor().getType() == Cursor.NW_RESIZE_CURSOR){
            	draggedComp.reshape(draggedComp.getLeft(),draggedComp.getTop(),
            						x-draggedComp.getLeft(), y-draggedComp.getTop());
             }
             else{
             	draggedComp.moveBy(x - prevDragX, y - prevDragY);
             }
             prevDragX = x;
	         prevDragY = y;
         }
         
        //Work the scrolling
        clickedComp.left = clickedComp.left + prevDragX - x;
		clickedComp.top = clickedComp.top + prevDragY - y;
		prevDragX = x;
	    prevDragY = y;
		Dimension dim = getPreferredSize();
		if (clickedComp.left+clickedComp.width > dim.width)
		{
			setPreferredSize(new Dimension(clickedComp.left+clickedComp.width,dim.height));
			Scroll.revalidate();
		}
		dim = getPreferredSize();
		if (clickedComp.top+clickedComp.height > dim.height)
		{
			setPreferredSize(new Dimension(dim.width,clickedComp.top+clickedComp.height));
			Scroll.revalidate();
		}
		Rectangle rect = Scroll.getViewport().getViewRect();
	  	Point pnt = Scroll.getViewport().getViewPosition();
		if (clickedComp.left < pnt.x) pnt.x = Math.max(0,clickedComp.left);
		if (clickedComp.top < pnt.y) pnt.y = Math.max(0,clickedComp.top);
		pnt.x = Math.max(pnt.x, pnt.x+(clickedComp.left+clickedComp.width)-(rect.x+rect.width));
		pnt.y = Math.max(pnt.y, pnt.y+(clickedComp.top+clickedComp.height)-(rect.y+rect.height));
		Scroll.getViewport().setViewPosition(pnt);
		 
		 
		 
         repaint();      // redraw canvas to show shape in new position
      }

      public void mouseReleased(MouseEvent evt) {
             // User has released the mouse.  Move the dragged shape, and set
             // draggedComp to null to indicate that dragging is over.
             // If the shape lies completely outside the canvas, remove it
             // from the list of shapes (since there is no way to ever move
             // it back on screen).  However, if the event is a popup trigger
             // event, then show the popup menu instead.
         if (draggedComp == null) {
               // User did not click on a shape. There is nothing to do.
            return;
         }
         px = evt.getX();
         py = evt.getY();
         if (evt.isPopupTrigger()) {
               // Check whether the user is trying to pop up a menu.
               // (This should be checked in both the mousePressed() and
               // mouseReleased() methods.)
            int[] var = clickedComp.variableAtPoint(px,py);
            if( var[0] == 3){
            	vStartpopup.show(this,px-10,py-2);
            }
            else if( var[0] == 1){
            	vEndpopup.show(this,px-10,py-2);
            }
            else if( var[0] == 2){
            	vMidpopup.show(this,px-10,py-2);
            }
            else{
            	popup.show(this,px-10,py-2);
            }
         }
         else {
            if(this.getCursor().getType() == Cursor.NW_RESIZE_CURSOR){
            	draggedComp.reshape(draggedComp.getLeft(),draggedComp.getTop(),
            						px-draggedComp.getLeft(), py-draggedComp.getTop());
            }
            else{
            	draggedComp.moveBy(px - prevDragX, py - prevDragY);
            }
            
            
         }
         
         repaint();
         draggedComp = null;  // Dragging is finished.
      }

      public void mouseEntered(MouseEvent evt) {}
      public void mouseExited(MouseEvent evt) {}
      public void mouseMoved(MouseEvent evt) {
      	if(getComponentResizeMouse(evt.getX(), evt.getY()) != null) {
      		this.setCursor(new Cursor(Cursor.NW_RESIZE_CURSOR));
      	}
      	else{
      		this.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));	
      	}
      }
      
      public void mouseClicked(MouseEvent evt) { 
      	if(clickedComp != null){
      		int x = evt.getX();
	        int y = evt.getY();
	        if (evt.getClickCount() == 2){
	      		myComponent s = getComponentMouse(x, y);
	      		actionPerformed(new ActionEvent(this,
         							ActionEvent.ACTION_PERFORMED,
         							"Edit Component"));

	      		
	      	}
      	}
      	else{
      	}
      	repaint();
      }

   }  // end class guicCanvas
   
	class LastFirstComparator implements Comparator
	{
	  public int compare(Object obj1, Object obj2)
	  {
	    int result = 0;
	 
	    String[] str1 = (String[]) obj1;
	    String[] str2 = (String[]) obj2;
	 
	    /* Sort on first element of each array (last name) */
	    if ((result = str1[0].compareTo(str2[0])) == 0)
	    {
	      /* If same last name, sort on second element (first name) */
	      result = str1[1].compareTo(str2[1]);
	    }
	 
	    return result;
	  }
	}
}  // end class guicellml