
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import javax.swing.border.EmptyBorder;
import javax.swing.*;
import javax.swing.colorchooser.*;
 
public class VariableOptionPanel extends JDialog implements ActionListener,
                                          ChangeListener {
 
    private String response;
    
    private JTextField	nameField;
    private JTextField initField;
    private JTextField unitField;
    private JComboBox  pubBox;
	private Color color;
 	private JColorChooser tcc;
 	JButton bcc;
 	
	/**
     * Class Constructor.
     */
	public VariableOptionPanel( JFrame parent , boolean modal, Variable v ) {
    	super( parent , modal );
		initComponents(v);
    }
 
	/**
     * This method is called within the constructor to
     * initialize the form.
     */
	private void initComponents(Variable v) {
		color = v.getColor();
        setTitle( "Edit " + v.getName());
        setResizable( true );
        setLocationRelativeTo( null );
 
        JPanel panel = new JPanel( new BorderLayout() );
        
		panel.setBorder( new EmptyBorder( new Insets( 5, 5, 5, 5) ) );
        getContentPane().add( BorderLayout.CENTER, panel );
 
		JPanel middlePanel = new JPanel( new GridLayout( 0,2 ) );
        JPanel buttonPanel = new JPanel( new FlowLayout( FlowLayout.RIGHT ) );
 
		panel.add( middlePanel , BorderLayout.CENTER );
        panel.add( buttonPanel , BorderLayout.SOUTH );
 
 
 
		JLabel label1 = new JLabel("Name");
		JLabel label2 = new JLabel("Value");
		JLabel label3 = new JLabel("Units");
		JLabel label4 = new JLabel("Pub");
 		JLabel label5 = new JLabel("Colour");
 		
		nameField = new JTextField(v.getName() + " ");
		String initString = "";
		if(!(v.getInit() == null)){
			initString = v.getInit().toString();
		}
		initField = new JTextField(initString);
		String[] Pubs= { "in", "", "out" };
		unitField = new JTextField(v.getUnits());
		pubBox = new JComboBox(Pubs);
 		pubBox.setSelectedItem(v.getPub());
 		bcc = new JButton("set colour");
 		bcc.setBackground(color);
        bcc.addActionListener(this);
 		
		middlePanel.add( label1 );
		middlePanel.add( nameField );
		middlePanel.add( label2 );
		middlePanel.add( initField );
		middlePanel.add( label3 );
		middlePanel.add( unitField );
		middlePanel.add( label4 );
		middlePanel.add( pubBox );
 		middlePanel.add( label5 );
		middlePanel.add( bcc );
		
        JButton okBtn = new JButton( "OK" );
		buttonPanel.add( okBtn );
        okBtn.setActionCommand( "OK" );
        okBtn.addActionListener( new ButtonListener() );
                
        JButton cancelBtn = new JButton( "Cancel" );
		buttonPanel.add( cancelBtn );
        cancelBtn.setActionCommand( "Cancel" );
        cancelBtn.addActionListener( new ButtonListener() );
      
        WindowListener wndCloser = new WindowAdapter() {
        	public void WindowClosing( WindowEvent evt ) {
				closeDialog( evt );
            }
        };
        addWindowListener( wndCloser );
		pack();
	
	}
	public void actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(
                                       VariableOptionPanel.this,
                                       "Choose Color",
                                       color);
        if (newColor != null) {
           color = newColor;
           bcc.setBackground(color);
        }
    }

    public void stateChanged(ChangeEvent e) {
    }
 
	/** Closes the dialog **/
	private void closeDialog( WindowEvent evt ) {
		setVisible( false );
		dispose();
	}
 
    /**
	 * @param args	The command line arguments.
	 */
	public static void main( String args[] ) {
		new VariableOptionPanel( new JFrame() , true, new Variable(-1,-1) ).show();
	}
 
    /**
     * Returns the value of Input 1.
     *
     * @return String	Value of Input 1.
     */    
    public String getNameField() {
		String value = null;
		if (nameField.getText() != null) {
			value = nameField.getText().trim();
		}	
    	return value;
    }
 	public Color getColorField() {
		Color value = null;
		if (color != null) {
			value = color;
		}	
    	return value;
    }
    /**
     * Returns the value of Input 1.
     *
     * @return String	Value of Input 1.
     */    
    public String getInitField() {
		String value = null;
		if (!initField.getText().equals("")) {
			value = initField.getText();
		}	
    	return value;
    }
    
    public String getUnitField() {
		String value = null;
		if (unitField.getText() != null) {
			value = unitField.getText();
		}	
    	return value;
    }
 
    /**
     * Returns the value of Input 1.
     *
     * @return String	Value of Input 1.
     */    
    public String getPubBox() {
		String value = null;
		if ((String)pubBox.getSelectedItem() != null) {
			value = (String)pubBox.getSelectedItem();
		}	
    	return value;
    }
 
    /**
     * Returns the response from the dialog box.
     *
     * @return String	Response string for dialog box.
	 *					equals "OK" if user hits OK.
	 *                  equals null if user cancels.
     */    
    public String getResponse() {
    	return response;
    }
 
    /**
	 * Action listener to listen to the buttons.
	 */
    class ButtonListener implements ActionListener {
        public void actionPerformed( ActionEvent e ) {
        	if ( e.getActionCommand().equals( "OK" ) ) {
                response = "OK";  
            	hide();
        	} else if ( e.getActionCommand().equals( "Cancel" ) ) {
                response = null;  
            	hide();
        	}
        }
    }
}
