import java.util.ArrayList;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import javax.swing.border.EmptyBorder;
import javax.swing.*;
import javax.swing.colorchooser.*;
 
public class UnitsPanel extends JDialog implements ActionListener,
                                          ChangeListener {
 
    private String response;
    
    private ArrayList units;

	
	/**
     * Class Constructor.
     */
	public UnitsPanel( JFrame parent, boolean modal, ArrayList unitsin ) {
		super( parent , modal );
		units = unitsin;
		setSize(600, 400);
		setLocationRelativeTo( null );
		initComponents(units);
    }
 
	/**
     * This method is called within the constructor to
     * initialize the form.
     */
	private void initComponents(ArrayList units) {
        setTitle( "Edit Units ");
        setResizable( false );
 	
    	JPanel pane = new JPanel(); 
		pane.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 1;
		c.weighty = 0;
		c.gridwidth = 1;
		c.gridheight = 1;
		
		JButton button;
		button = new JButton("Add a new unit");
		button.addActionListener(this);
		c.gridx = 0;
		c.gridwidth = 2;
		c.gridy = 0;
		pane.add(button,c);
		

		c.gridwidth = 1;
		Color unitbc = new Color(180,180,255);
		Color delubc = new Color(255,180,180);
		for(int i=0; i<units.size(); i++){
			Unit u = (Unit)units.get(i);
			button = new JButton(u.getName());
			button.setBackground(unitbc);
			button.addActionListener(this);
			c.gridx = 0;
			c.gridy = i+1;
			pane.add(button,c);
			button = new JButton("Delete "+ u.getName());
			button.setBackground(delubc);
			button.addActionListener(this);
			c.gridx = 1;
			c.gridy = i+1;
			pane.add(button,c);
					
		}


		//Put in the ok and cancel buttons
		JButton okBtn = new JButton( "OK" );
		c.gridx = 0;
		c.gridy = units.size()+2;
		pane.add(okBtn, c );
        okBtn.setActionCommand( "OK" );
        okBtn.addActionListener( new ButtonListener() );
                
        JButton cancelBtn = new JButton( "Cancel" );
		c.gridx = 1;
		c.gridy = units.size()+2;
		pane.add(cancelBtn, c );
        cancelBtn.setActionCommand( "Cancel" );
        cancelBtn.addActionListener( new ButtonListener() );

		getContentPane().add( BorderLayout.CENTER, pane );    
		pack();
	
	}
	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		if(command.equals("Add a new unit")){
			Unit tempu = new Unit();
			unitOptionPanel md = new unitOptionPanel(null,true, tempu);
			md.setLocation(200,200);
			md.setVisible( true );
			if (md.getResponse().equals("OK")) {
			    tempu.setName(md.getNameField());
			    tempu.clearSubs();
			    ArrayList subs = md.getSubUnits();
			    for(int j=0; j<subs.size(); j++){
			    	tempu.addSubUnit((Unit)subs.get(j));
			    }
			    units.add(tempu);
			    md.dispose();
			} else {
			    md.dispose();
			}	
		}
		if(command.indexOf("Delete")==0){
			for(int i=0; i<units.size(); i++){
				Unit tempu = (Unit)units.get(i);
				if(tempu.getName().equals(command.substring(7,command.length()))){
					units.remove(i);
					break;
				}
			}		
		}
		else{
			Unit tempu = null;
			for(int i=0; i<units.size(); i++){
				tempu = (Unit)units.get(i);
				if(tempu.getName().equals(command)){
					unitOptionPanel md = new unitOptionPanel(null,true, tempu);
					md.setLocation(200,200);
					md.setVisible( true );
					if (md.getResponse().equals("OK")) {
					    tempu.setName(md.getNameField());
					    tempu.clearSubs();
					    ArrayList subs = md.getSubUnits();
					    for(int j=0; j<subs.size(); j++){
					    	tempu.addSubUnit((Unit)subs.get(j));
					    }
					    md.dispose();
					} else {
					    md.dispose();
					}						
				}//end finding the unit
			}//end searching for the unit			
		}//end that it's an edit not a delete
		
		//Update the units and show them
		getContentPane().removeAll();
		initComponents(units);			        
    }//end actionPerformed

    public void stateChanged(ChangeEvent e) {
    }

 
    /**
	 * @param args	The command line arguments.
	 */
	public static void main( String args[] ) {
		ArrayList units = new ArrayList();
        Unit flow = new Unit("flow");
        units.add(flow);
        Unit ml = new Unit("ml");
        units.add(ml);
        Unit litre = new Unit("litre");
        units.add(litre);
        Unit second = new Unit("second");
        units.add(second);
        
        litre.setPref("milli");
        ml.addSubUnit(litre);
        
        second.setExpo(-1.0);
        second.setOffset(-51.0);
        flow.addSubUnit(ml);
        flow.addSubUnit(second);
        
        new UnitsPanel(new JFrame() , true, units ).show();
		
	}
 
    public ArrayList getUnits(){
    	return units;
    }



    /**
     * Returns the response from the dialog box.
     *
     * @return String	Response string for dialog box.
	 *					equals "OK" if user hits OK.
	 *                  equals null if user cancels.
     */    
    public String getResponse() {
    	return response;
    }
 
    /**
	 * Action listener to listen to the buttons.
	 */
    class ButtonListener implements ActionListener {
        public void actionPerformed( ActionEvent e ) {
        	if ( e.getActionCommand().equals( "OK" ) ) {
                response = "OK";  
            	hide();
        	} else if ( e.getActionCommand().equals( "Cancel" ) ) {
                response = null;  
            	hide();
        	}
        }
    }
}
