import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class Join {
   	myComponent fromc;
   	Variable fromv;
   	myComponent toc;
   	Variable tov;
   	
   	Join(myComponent fromc, Variable fromv, myComponent toc, Variable tov){
   		this.setFrom(fromc, fromv);
   		this.setTo(toc, tov);
   	}
   	void setFrom(myComponent c, Variable v){
   		fromc = c;
   		fromv = v;
   	}
   	void setTo(myComponent c, Variable v){
   		toc = c;
   		tov = v;
   	}
   	
   	int[] getVarIDS(){
   		int[] IDs = new int[4];
   		IDs[0] = fromc.getID();
   		IDs[1] = toc.getID();
   		IDs[2] = fromv.getID();
   		IDs[3] = tov.getID();
   		return IDs;
   	}
   	
   	myComponent getFromc(){
   		return fromc;
   	}
   	Variable getFromv(){
   		return fromv;
   	}
   	myComponent getToc(){
   		return toc;
   	}
   	Variable getTov(){
   		return tov;
   	}
   	
   	void draw(Graphics g){
   		g.setColor(Color.black); 
   		g.drawLine(	
   			fromc.getLeft()+fromc.getWidth(), //fromx
   			fromc.top+(fromc.height/fromc.numVarOut())*fromv.getCRow() + (fromc.height/fromc.numVarOut())/2, //fromy
   			toc.getLeft(), //tox
   			toc.top+(toc.height/toc.numVarIn())*tov.getCRow() + (toc.height/toc.numVarIn()/2) //toy
   			);
   	}
}