/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VariableOptionPanel
extends JDialog
implements ActionListener,
ChangeListener {
    private String response;
    private JTextField nameField;
    private JTextField initField;
    private JTextField unitField;
    private JComboBox pubBox;
    private Color color;
    private JColorChooser tcc;
    JButton bcc;

    public VariableOptionPanel(JFrame jFrame, boolean bl, Variable variable) {
        super((Frame)jFrame, bl);
        this.initComponents(variable);
    }

    private void initComponents(Variable variable) {
        this.color = variable.getColor();
        this.setTitle("Edit " + variable.getName());
        this.setResizable(true);
        this.setLocationRelativeTo(null);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.getContentPane().add("Center", jPanel);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2));
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        JLabel jLabel = new JLabel("Name");
        JLabel jLabel2 = new JLabel("Value");
        JLabel jLabel3 = new JLabel("Units");
        JLabel jLabel4 = new JLabel("Pub");
        JLabel jLabel5 = new JLabel("Colour");
        this.nameField = new JTextField(variable.getName() + " ");
        String string = "";
        if (variable.getInit() != null) {
            string = variable.getInit().toString();
        }
        this.initField = new JTextField(string);
        String[] stringArray = new String[]{"in", "", "out"};
        this.unitField = new JTextField(variable.getUnits());
        this.pubBox = new JComboBox<String>(stringArray);
        this.pubBox.setSelectedItem(variable.getPub());
        this.bcc = new JButton("set colour");
        this.bcc.setBackground(this.color);
        this.bcc.addActionListener(this);
        jPanel2.add(jLabel);
        jPanel2.add(this.nameField);
        jPanel2.add(jLabel2);
        jPanel2.add(this.initField);
        jPanel2.add(jLabel3);
        jPanel2.add(this.unitField);
        jPanel2.add(jLabel4);
        jPanel2.add(this.pubBox);
        jPanel2.add(jLabel5);
        jPanel2.add(this.bcc);
        JButton jButton = new JButton("OK");
        jPanel3.add(jButton);
        jButton.setActionCommand("OK");
        jButton.addActionListener(new ButtonListener());
        JButton jButton2 = new JButton("Cancel");
        jPanel3.add(jButton2);
        jButton2.setActionCommand("Cancel");
        jButton2.addActionListener(new ButtonListener());
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void WindowClosing(WindowEvent windowEvent) {
                VariableOptionPanel.this.closeDialog(windowEvent);
            }
        };
        this.addWindowListener(windowAdapter);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, "Choose Color", this.color);
        if (color != null) {
            this.color = color;
            this.bcc.setBackground(this.color);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new VariableOptionPanel(new JFrame(), true, new Variable(-1, -1)).show();
    }

    public String getNameField() {
        String string = null;
        if (this.nameField.getText() != null) {
            string = this.nameField.getText().trim();
        }
        return string;
    }

    public Color getColorField() {
        Color color = null;
        if (this.color != null) {
            color = this.color;
        }
        return color;
    }

    public String getInitField() {
        String string = null;
        if (!this.initField.getText().equals("")) {
            string = this.initField.getText();
        }
        return string;
    }

    public String getUnitField() {
        String string = null;
        if (this.unitField.getText() != null) {
            string = this.unitField.getText();
        }
        return string;
    }

    public String getPubBox() {
        String string = null;
        if ((String)this.pubBox.getSelectedItem() != null) {
            string = (String)this.pubBox.getSelectedItem();
        }
        return string;
    }

    public String getResponse() {
        return this.response;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("OK")) {
                VariableOptionPanel.this.response = "OK";
                VariableOptionPanel.this.hide();
            } else if (actionEvent.getActionCommand().equals("Cancel")) {
                VariableOptionPanel.this.response = null;
                VariableOptionPanel.this.hide();
            }
        }
    }
}

