/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VariablesTableModel
extends AbstractTableModel {
    public static final int NAME_INDEX = 0;
    public static final int UNITS_INDEX = 1;
    public static final int INIT_INDEX = 2;
    public static final int PUB_INDEX = 3;
    public static final int HIDDEN_INDEX = 4;
    protected String[] columnNames;
    protected Vector data;

    public VariablesTableModel() {
        this.columnNames = this.columnNames = new String[]{"Name", "Units", "Init", "Pub", ""};
        this.data = new Vector(5);
    }

    public String getColumnNames(int n) {
        return this.columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 4;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                return String.class;
            }
            case 2: {
                return Double.class;
            }
        }
        return Object.class;
    }

    public Variable getVar(int n) {
        Variable variable = (Variable)this.data.get(n);
        return variable;
    }

    public String getVarName(int n) {
        Variable variable = (Variable)this.data.get(n);
        return variable.getname();
    }

    public String getVarUnits(int n) {
        Variable variable = (Variable)this.data.get(n);
        return variable.getunits();
    }

    public Double getVarInit(int n) {
        Variable variable = (Variable)this.data.get(n);
        return variable.getinit();
    }

    public String getVarPub(int n) {
        Variable variable = (Variable)this.data.get(n);
        return variable.getpub();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Variable variable = (Variable)this.data.get(n);
        switch (n2) {
            case 0: {
                return variable.getname();
            }
            case 1: {
                return variable.getunits();
            }
            case 2: {
                return variable.getinit();
            }
            case 3: {
                return variable.getpub();
            }
        }
        return new Object();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Variable variable = (Variable)this.data.get(n);
        switch (n2) {
            case 0: {
                variable.setname((String)object);
                break;
            }
            case 1: {
                variable.setunits((String)object);
                break;
            }
            case 2: {
                variable.setinit((Double)object);
                break;
            }
            case 3: {
                variable.setpub((String)object);
                break;
            }
            default: {
                System.out.println("invalid index");
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public boolean hasEmptyRow() {
        if (this.data.size() == 0) {
            return false;
        }
        Variable variable = (Variable)this.data.get(this.data.size() - 1);
        return variable.getname().trim().equals("") && variable.getunits().trim().equals("") && variable.getinit().toString().trim().equals("") && variable.getpub().trim().equals("");
    }

    public void addEmptyRow() {
        this.data.add(new Variable(this.data.size()));
        this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
    }

    public void removeRow(int n) {
        this.data.remove(n);
        this.fireTableRowsDeleted(n, n);
    }
}

