/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class InternalFrameDemo
extends JFrame
implements ActionListener,
MouseListener {
    myJDesktopPane desktop;
    ArrayList Components = new ArrayList();
    ArrayList JoinArray = new ArrayList();

    public InternalFrameDemo() {
        super("Project");
        int n = 250;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(n, n, dimension.width - n * 2, dimension.height - n * 2);
        this.desktop = new myJDesktopPane();
        this.desktop.addMouseListener(this);
        this.createComponent();
        this.setContentPane(this.desktop);
        this.setJMenuBar(this.createMenuBar());
        this.desktop.setDragMode(1);
    }

    public void printout(String string) {
        System.out.println(string);
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Component");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.setMnemonic(78);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        jMenuItem.setActionCommand("new");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Quit");
        jMenuItem.setMnemonic(81);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        jMenuItem.setActionCommand("quit");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("CellML");
        jMenuBar.add(jMenu2);
        JMenuItem jMenuItem2 = new JMenuItem("Write COR");
        jMenuItem2.setActionCommand("writeCOR");
        jMenuItem2.addActionListener(this);
        jMenu2.add(jMenuItem2);
        return jMenuBar;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("new".equals(string)) {
            this.createComponent();
        } else if ("writeCOR".equals(string)) {
            int n = this.Components.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                Component component = (Component)this.Components.get(i);
                System.out.println("def comp " + component.getTitle() + " as");
                for (n2 = 0; n2 < component.numVars(); ++n2) {
                    System.out.print("var " + component.getVarName(n2) + ": ");
                    System.out.print(component.getVarUnits(n2) + " ");
                    if (component.getVarInit(n2) == null) {
                        System.out.print("{");
                    } else {
                        System.out.print("{init: " + component.getVarInit(n2));
                    }
                    if (component.getVarPub(n2).equals("")) {
                        System.out.print("};");
                    } else {
                        System.out.print(" pub: " + component.getVarPub(n2) + "};");
                    }
                    System.out.println();
                }
                for (n2 = 0; n2 < component.numEqs(); ++n2) {
                    System.out.println(" " + component.getEq(n2));
                }
                n2 = this.JoinArray.size();
                for (int j = 0; j < n2; ++j) {
                    Join join = (Join)this.JoinArray.get(j);
                    Component component2 = (Component)this.Components.get(join.getFromc());
                    Component component3 = (Component)this.Components.get(join.getToc());
                    System.out.print("def map between " + component2.getTitle());
                    System.out.println(" and " + component3.getTitle() + " for");
                    System.out.print("vars " + component2.getVarName(join.getFromv()));
                    System.out.println(" and " + component2.getVarName(join.getTov()) + ";");
                    System.out.println("enddef;");
                }
                System.out.println("enddef;");
            }
        } else {
            this.quit();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (Joins.isFull()) {
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < this.Components.size(); ++i) {
                Component component = (Component)this.Components.get(i);
                if (component.getID() == Joins.fromc) {
                    n = component.getID();
                }
                if (component.getID() != Joins.toc) continue;
                n2 = component.getID();
            }
            Join join = new Join(n, Joins.fromv.getID(), n2, Joins.tov.getID());
            this.JoinArray.add(join);
            Joins.clear();
        }
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    protected void createComponent() {
        Component component = new Component(this.Components.size());
        component.setVisible(true);
        component.addMouseListener(this);
        this.desktop.add(component);
        this.Components.add(component);
        try {
            component.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.repaint();
    }

    protected void quit() {
        System.exit(0);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        InternalFrameDemo internalFrameDemo = new InternalFrameDemo();
        internalFrameDemo.setDefaultCloseOperation(3);
        internalFrameDemo.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InternalFrameDemo.createAndShowGUI();
            }
        });
    }

    public class myJDesktopPane
    extends JDesktopPane {
        myJDesktopPane() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(Color.black);
            for (int i = 0; i < InternalFrameDemo.this.JoinArray.size(); ++i) {
                Join join = (Join)InternalFrameDemo.this.JoinArray.get(i);
                Component component = (Component)InternalFrameDemo.this.Components.get(join.getFromc());
                Component component2 = (Component)InternalFrameDemo.this.Components.get(join.getToc());
                int n = component.getBounds().x + component.getBounds().width;
                int n2 = component.getBounds().y + join.getFromv() * 20 + 75;
                int n3 = component2.getBounds().x;
                int n4 = component2.getBounds().y + join.getTov() * 20 + 75;
                graphics.drawLine(n, n2, n3, n4);
            }
        }
    }
}

