/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class EquationForm
extends JPanel
implements MouseListener,
ActionListener,
TableModelListener {
    protected JTable table;
    protected JScrollPane scroller;
    protected EquationsTableModel tableModel;
    protected JPopupMenu popup;
    String[] Equations;
    public Point p;

    public EquationForm() {
        this.initComponent();
    }

    public void initComponent() {
        this.tableModel = new EquationsTableModel();
        this.tableModel.addTableModelListener(new EquationTableModelListener());
        this.table = new JTable();
        this.table.setRowHeight(20);
        this.table.setModel(this.tableModel);
        this.table.setAutoResizeMode(4);
        this.table.setSurrendersFocusOnKeystroke(true);
        if (!this.tableModel.hasEmptyRow()) {
            this.tableModel.addEmptyRow();
        }
        this.tableModel.addTableModelListener(this);
        this.scroller = new JScrollPane(this.table);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setMinWidth(2);
        tableColumn.setPreferredWidth(2);
        tableColumn.setMaxWidth(2);
        tableColumn.setCellRenderer(new VarsRenderer(1));
        this.popup = new JPopupMenu();
        this.popup.add("Add an equation").addActionListener(this);
        this.popup.add("Delete the equation").addActionListener(this);
        this.table.addMouseListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller, "Center");
        this.repaint();
    }

    public void highlightLastRow(int n) {
        int n2 = this.tableModel.getRowCount();
        if (n == n2 - 1) {
            this.table.setRowSelectionInterval(n2 - 1, n2 - 1);
        } else {
            this.table.setRowSelectionInterval(n + 1, n + 1);
        }
        this.table.setColumnSelectionInterval(0, 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add an equation")) {
            this.tableModel.addEmptyRow();
        } else if (string.equals("Delete the equation")) {
            try {
                this.tableModel.removeRow(this.table.rowAtPoint(this.p));
            }
            catch (Exception exception) {
                System.out.println("Error deleting equation: " + exception);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.p = mouseEvent.getPoint();
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(this, this.p.x - 10, this.p.y - 2);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.p = mouseEvent.getPoint();
        if (mouseEvent.isPopupTrigger()) {
            this.popup.show(this, this.p.x - 10, this.p.y - 2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            JFrame jFrame = new JFrame("Variable Form");
            jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            jFrame.getContentPane().add(new VariableForm());
            jFrame.pack();
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        TableModel tableModel = (TableModel)tableModelEvent.getSource();
        String string = tableModel.getColumnName(n2);
        Object object = tableModel.getValueAt(n, n2);
    }

    public class EquationTableModelListener
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 0) {
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                EquationForm.this.table.setColumnSelectionInterval(n + 1, n + 1);
                EquationForm.this.table.setRowSelectionInterval(n2, n2);
            }
        }
    }

    class VarsRenderer
    extends DefaultTableCellRenderer {
        protected int interactiveColumn;

        public VarsRenderer(int n) {
            this.interactiveColumn = n;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == this.interactiveColumn && bl2) {
                if (EquationForm.this.tableModel.getRowCount() - 1 == n && !EquationForm.this.tableModel.hasEmptyRow()) {
                    EquationForm.this.tableModel.addEmptyRow();
                }
                EquationForm.this.highlightLastRow(n);
            }
            return component;
        }
    }
}

