/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;

public class myComponent {
    int id;
    int left;
    int top;
    int width;
    int height;
    Color color = Color.gray;
    String name;
    String equations;
    ArrayList variables = new ArrayList();

    public myComponent(int n) {
        this.id = n;
        this.equations = "";
    }

    void reshape(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.width = n3;
        this.height = n4;
    }

    void setSize(int n, int n2) {
        this.width = n + 20;
        this.height = n2 + 5;
    }

    int getLeft() {
        return this.left;
    }

    int getTop() {
        return this.top;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    String getEquations() {
        if (this.equations == null) {
            return "";
        }
        return this.equations;
    }

    void setEquations(String string) {
        this.equations = string;
    }

    int getID() {
        return this.id;
    }

    void setID(int n) {
        this.id = n;
    }

    ArrayList getVariables() {
        return this.variables;
    }

    void moveBy(int n, int n2) {
        this.left += n;
        this.top += n2;
    }

    boolean containsPoint(int n, int n2) {
        return n >= this.left && n < this.left + this.width && n2 >= this.top && n2 < this.top + this.height;
    }

    boolean containsResizePoint(int n, int n2) {
        return n >= this.left + this.width - 5 && n < this.left + this.width && n2 >= this.top + this.height - 5 && n2 < this.top + this.height;
    }

    int[] variableAtPoint(int n, int n2) {
        int[] nArray = new int[]{-1, -1};
        if (n >= this.left && n < this.left + this.width / 3) {
            try {
                nArray[0] = 1;
                nArray[1] = (n2 - this.top) / (this.height / this.numVarIn());
            }
            catch (Exception exception) {}
        } else if (n >= this.left + this.width / 3 * 2 && n < this.left + this.width) {
            try {
                nArray[0] = 3;
                nArray[1] = (n2 - this.top) / (this.height / this.numVarOut());
            }
            catch (Exception exception) {}
        } else {
            try {
                nArray[0] = 2;
                nArray[1] = (n2 - this.top) / (this.height / this.numVarMid());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nArray;
    }

    int variableIDfromColRow(int n, int n2) {
        int n3 = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.get(i);
            if (variable.getPub().equals("in") && n == 1) {
                ++n3;
            } else if (variable.getPub().equals("out") && n == 3) {
                ++n3;
            } else if (variable.getPub().equals("") && n == 2) {
                ++n3;
            }
            if (n3 != n2) continue;
            return variable.getID();
        }
        return -1;
    }

    Variable variableFromColRow(int n, int n2) {
        int n3 = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.get(i);
            if (variable.getPub().equals("in") && n == 1) {
                ++n3;
            } else if (variable.getPub().equals("out") && n == 3) {
                ++n3;
            } else if (variable.getPub().equals("") && n == 2) {
                ++n3;
            }
            if (n3 != n2) continue;
            return variable;
        }
        return new Variable(-1, -1);
    }

    Variable variableByName(String string) {
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.get(i);
            if (!variable.getName().equals(string)) continue;
            return variable;
        }
        return null;
    }

    void addVariable(Variable variable) {
        this.variables.add(variable);
        int n = 0;
        n = variable.getPub().equals("in") ? this.numVarIn() : (variable.getPub().equals("out") ? this.numVarOut() : this.numVarMid());
        variable.setCRow(n - 1);
    }

    void deleteVariable(int n) {
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.get(i);
            if (variable.getID() != n) continue;
            this.variables.remove(i);
            break;
        }
        this.updateVariableRows();
    }

    void updateVariableRows() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.get(i);
            n4 = variable.getPub().equals("in") ? n++ : (variable.getPub().equals("out") ? n3++ : n2++);
            variable.setCRow(n4);
        }
    }

    void draw(Graphics graphics) {
        graphics.setColor(this.color);
        graphics.fillRect(this.left, this.top, this.width, this.height);
        graphics.setColor(Color.black);
        graphics.drawRect(this.left, this.top, this.width, this.height);
        Font font = new Font("Serif", 0, 12);
        graphics.setFont(font);
        graphics.drawString(this.name, this.left, this.top - 1);
        int n = this.variables.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n; ++i) {
            int n8 = (this.width - 4) / 3;
            Variable variable = (Variable)this.variables.get(i);
            if (variable.getPub().equals("in")) {
                n2 = this.left + 2;
                n3 = this.top + (this.height - 4) / this.numVarIn() * variable.getCRow() + 2;
                n4 = (this.height - 4) / this.numVarIn();
                ++n5;
            } else if (variable.getPub().equals("out")) {
                n2 = this.left + (this.width - 4) / 3 * 2 + 2;
                n3 = this.top + (this.height - 4) / this.numVarOut() * variable.getCRow() + 2;
                n4 = (this.height - 4) / this.numVarOut();
                ++n6;
            } else {
                n2 = this.left + (this.width - 4) / 3 + 2;
                n3 = this.top + (this.height - 4) / this.numVarMid() * variable.getCRow() + 2;
                n4 = (this.height - 4) / this.numVarMid();
                ++n7;
            }
            graphics.setColor(variable.getColor());
            graphics.fillRect(n2, n3, n8, n4);
            graphics.setColor(Color.black);
            graphics.drawRect(n2, n3, n8, n4);
        }
    }

    void showAll() {
        System.out.println(this.name);
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.get(i);
            System.out.println(variable.getName());
        }
    }

    int numVarIn() {
        int n = 0;
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.get(i);
            if (!variable.getPub().equals("in")) continue;
            ++n;
        }
        return n;
    }

    int numVarOut() {
        int n = 0;
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.get(i);
            if (!variable.getPub().equals("out")) continue;
            ++n;
        }
        return n;
    }

    int numVarMid() {
        int n = 0;
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable variable = (Variable)this.variables.get(i);
            if (!variable.getPub().equals("")) continue;
            ++n;
        }
        return n;
    }
}

