/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class guicellml
extends JFrame {
    JScrollPane Scroll;
    JPopupMenu popup;
    JPopupMenu vStartpopup;
    JPopupMenu vEndpopup;
    JPopupMenu vMidpopup;
    int cIDcount = 0;
    int vIDcount = 0;

    public static void main(String[] stringArray) {
        new guicellml();
    }

    public guicellml() {
        super("GUIcellML v1.0");
        guicCanvas guicCanvas2 = new guicCanvas();
        this.Scroll = new JScrollPane(guicCanvas2, 22, 32);
        this.setContentPane(this.Scroll);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Model");
        jMenu2.setMnemonic('M');
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic('H');
        jMenuBar.add(jMenu3);
        JMenuItem jMenuItem = new JMenuItem("Add Component");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("ctrl N"));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(guicCanvas2);
        JMenuItem jMenuItem2 = new JMenuItem("Add Variable");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke("ctrl M"));
        jMenu2.add(jMenuItem2);
        jMenuItem2.addActionListener(guicCanvas2);
        JMenuItem jMenuItem3 = new JMenuItem("Units");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke("ctrl U"));
        jMenu2.add(jMenuItem3);
        jMenuItem3.addActionListener(guicCanvas2);
        JMenuItem jMenuItem4 = new JMenuItem("Clear");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke("ctrl C"));
        jMenuItem4.addActionListener(guicCanvas2);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Save");
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke("ctrl S"));
        jMenuItem5.addActionListener(guicCanvas2);
        jMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Load");
        jMenuItem6.addActionListener(guicCanvas2);
        jMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Write COR");
        jMenuItem7.addActionListener(guicCanvas2);
        jMenu2.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("About");
        jMenuItem8.addActionListener(guicCanvas2);
        jMenu3.add(jMenuItem8);
        this.popup = new JPopupMenu();
        this.popup.add("Add Variable").addActionListener(guicCanvas2);
        this.popup.add("Edit Component").addActionListener(guicCanvas2);
        this.popup.add("Delete Component").addActionListener(guicCanvas2);
        this.popup.add("Bring to Front").addActionListener(guicCanvas2);
        this.popup.addSeparator();
        this.vStartpopup = new JPopupMenu();
        this.vStartpopup.add("Add Variable").addActionListener(guicCanvas2);
        this.vStartpopup.add("Edit Component").addActionListener(guicCanvas2);
        this.vStartpopup.add("Delete Component").addActionListener(guicCanvas2);
        this.vStartpopup.add("Bring to Front").addActionListener(guicCanvas2);
        this.vStartpopup.addSeparator();
        this.vStartpopup.add("Edit Variable").addActionListener(guicCanvas2);
        this.vStartpopup.add("Delete Variable").addActionListener(guicCanvas2);
        this.vStartpopup.add("Set Join Start").addActionListener(guicCanvas2);
        this.vEndpopup = new JPopupMenu();
        this.vEndpopup.add("Add Variable").addActionListener(guicCanvas2);
        this.vEndpopup.add("Edit Component").addActionListener(guicCanvas2);
        this.vEndpopup.add("Delete Component").addActionListener(guicCanvas2);
        this.vEndpopup.add("Bring to Front").addActionListener(guicCanvas2);
        this.vEndpopup.addSeparator();
        this.vEndpopup.add("Edit Variable").addActionListener(guicCanvas2);
        this.vEndpopup.add("Delete Variable").addActionListener(guicCanvas2);
        this.vEndpopup.add("Set Join End").addActionListener(guicCanvas2);
        this.vMidpopup = new JPopupMenu();
        this.vMidpopup.add("Add Variable").addActionListener(guicCanvas2);
        this.vMidpopup.add("Edit Component").addActionListener(guicCanvas2);
        this.vMidpopup.add("Delete Component").addActionListener(guicCanvas2);
        this.vMidpopup.add("Bring to Front").addActionListener(guicCanvas2);
        this.vMidpopup.addSeparator();
        this.vMidpopup.add("Edit Variable").addActionListener(guicCanvas2);
        this.vMidpopup.add("Delete Variable").addActionListener(guicCanvas2);
        this.setDefaultCloseOperation(3);
        this.setLocation(20, 50);
        this.setSize(550, 420);
        this.show();
    }

    class LastFirstComparator
    implements Comparator {
        LastFirstComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            String[] stringArray = (String[])object;
            String[] stringArray2 = (String[])object2;
            n = stringArray[0].compareTo(stringArray2[0]);
            if (n == 0) {
                n = stringArray[1].compareTo(stringArray2[1]);
            }
            return n;
        }
    }

    class guicCanvas
    extends JPanel
    implements ActionListener,
    MouseListener,
    MouseMotionListener {
        ArrayList components = new ArrayList();
        ArrayList componentFulls = new ArrayList();
        ArrayList joins = new ArrayList();
        ArrayList units = new ArrayList();
        myComponent currentJoinStartc = null;
        Variable currentJoinStartv = null;
        myComponent currentJoinEndc = null;
        Variable currentJoinEndv = null;
        int px;
        int py;
        myComponent clickedComp = null;
        myComponent draggedComp = null;
        myComponent resizeComp = null;
        int prevDragX;
        int prevDragY;

        guicCanvas() {
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            super.paintComponent(graphics);
            int n2 = this.components.size();
            for (n = 0; n < n2; ++n) {
                myComponent myComponent2 = (myComponent)this.components.get(n);
                myComponent2.draw(graphics);
                if (myComponent2 != this.clickedComp) continue;
                graphics.setColor(Color.blue);
                graphics.drawRect(myComponent2.getLeft() - 1, myComponent2.getTop() - 1, myComponent2.getWidth() + 2, myComponent2.getHeight() + 2);
            }
            n = this.joins.size();
            for (int i = 0; i < n; ++i) {
                Join join = (Join)this.joins.get(i);
                join.draw(graphics);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Clear")) {
                this.components.clear();
                this.joins.clear();
                guicellml.this.cIDcount = 0;
                guicellml.this.vIDcount = 0;
                this.repaint();
            } else if (string.equals("Add Component")) {
                this.addComponent();
            } else if (string.equals("About")) {
                JTextArea jTextArea = new JTextArea("        GUIcellML v1.0 \n  For more info or help,\n email d.cumin@auckland.ac.nz");
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setEditable(false);
                JFrame jFrame = new JFrame("About");
                jFrame.getContentPane().add(jTextArea);
                jFrame.setBounds(50, 50, 200, 100);
                jFrame.show(true);
            } else if (string.equals("Units")) {
                UnitsPanel unitsPanel = new UnitsPanel(new JFrame(), true, this.units);
                unitsPanel.setLocation(200, 200);
                unitsPanel.setVisible(true);
                if (unitsPanel.getResponse().equals("OK")) {
                    this.units = unitsPanel.getUnits();
                    unitsPanel.dispose();
                } else {
                    unitsPanel.dispose();
                }
            } else if (this.clickedComp != null) {
                if (string.equals("Delete Component")) {
                    this.components.remove(this.clickedComp);
                    for (int i = 0; i < this.joins.size(); ++i) {
                        Join join = (Join)this.joins.get(i);
                        int[] nArray = join.getVarIDS();
                        if (nArray[0] != this.clickedComp.getID() && nArray[1] != this.clickedComp.getID()) continue;
                        this.joins.remove(i);
                    }
                } else if (string.equals("Edit Component")) {
                    myComponentOptionPanel myComponentOptionPanel2 = new myComponentOptionPanel(null, true, this.clickedComp);
                    myComponentOptionPanel2.setLocation(this.px + 10, this.py + 10);
                    myComponentOptionPanel2.setVisible(true);
                    if (myComponentOptionPanel2.getResponse().equals("OK")) {
                        this.clickedComp.setName(myComponentOptionPanel2.getNameField());
                        this.clickedComp.setColor(myComponentOptionPanel2.getColorField());
                        this.clickedComp.setEquations(myComponentOptionPanel2.getEquationsField());
                        myComponentOptionPanel2.dispose();
                    } else {
                        myComponentOptionPanel2.dispose();
                    }
                } else if (string.equals("Bring to Front")) {
                    if (this.clickedComp != null) {
                        this.components.remove(this.clickedComp);
                        this.components.add(this.clickedComp);
                    }
                } else if (string.equals("Set Join Start")) {
                    if (this.clickedComp != null) {
                        this.currentJoinStartc = this.clickedComp;
                        int[] nArray = this.clickedComp.variableAtPoint(this.px, this.py);
                        this.currentJoinStartv = this.clickedComp.variableFromColRow(nArray[0], nArray[1]);
                    }
                } else if (string.equals("Set Join End")) {
                    if (this.clickedComp != null) {
                        this.currentJoinEndc = this.clickedComp;
                        int[] nArray = this.clickedComp.variableAtPoint(this.px, this.py);
                        this.currentJoinEndv = this.clickedComp.variableFromColRow(nArray[0], nArray[1]);
                    }
                } else if (string.equals("Add Variable") || string.equals("Variable")) {
                    if (this.clickedComp != null) {
                        this.addVariableToComponent(this.clickedComp);
                    } else {
                        JOptionPane.showMessageDialog(null, "There is no component selected!", "Error", 2);
                    }
                } else if (string.equals("Edit Variable")) {
                    if (this.clickedComp != null) {
                        this.editVariable();
                    }
                } else if (string.equals("Delete Variable") && this.clickedComp != null) {
                    int[] nArray = this.clickedComp.variableAtPoint(this.px, this.py);
                    int n = this.clickedComp.variableIDfromColRow(nArray[0], nArray[1]);
                    this.clickedComp.deleteVariable(n);
                    for (int i = 0; i < this.joins.size(); ++i) {
                        Join join = (Join)this.joins.get(i);
                        int[] nArray2 = join.getVarIDS();
                        if (nArray2[2] != n && nArray2[3] != n) continue;
                        this.joins.remove(i);
                    }
                }
            }
            if (string.equals("Write COR")) {
                this.writeCOR();
            } else if (string.equals("Save")) {
                File file = this.getFile("Save");
                new Save(this.saveXMLString(), file);
            } else if (string.equals("Load")) {
                File file = this.getFile("Load");
                this.Load(file);
            }
            if (this.currentJoinStartv != null && this.currentJoinEndv != null) {
                this.addJoin(new Join(this.currentJoinStartc, this.currentJoinStartv, this.currentJoinEndc, this.currentJoinEndv));
                this.currentJoinStartv = null;
                this.currentJoinEndv = null;
            }
            this.repaint();
        }

        File getFile(String string) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setApproveButtonText(string);
            jFileChooser.setDialogTitle(string);
            int n = jFileChooser.showDialog(this, string);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                return file;
            }
            return null;
        }

        void editVariable() {
            int[] nArray = this.clickedComp.variableAtPoint(this.px, this.py);
            Variable variable = this.clickedComp.variableFromColRow(nArray[0], nArray[1]);
            VariableOptionPanel variableOptionPanel = new VariableOptionPanel(null, true, variable);
            variableOptionPanel.setLocation(this.px + 10, this.py + 10);
            variableOptionPanel.setVisible(true);
            if (variableOptionPanel.getResponse().equals("OK")) {
                variable.setName(variableOptionPanel.getNameField());
                if (variableOptionPanel.getInitField() != null) {
                    variable.setInit(Double.parseDouble(variableOptionPanel.getInitField()));
                }
                variable.setUnits(variableOptionPanel.getUnitField());
                variable.setPub(variableOptionPanel.getPubBox());
                variable.setColor(variableOptionPanel.getColorField());
                this.clickedComp.updateVariableRows();
                variableOptionPanel.dispose();
            } else {
                variableOptionPanel.dispose();
            }
        }

        void writeCOR() {
            Serializable serializable;
            Object object;
            String string = "";
            int n = this.components.size();
            string = string + "def model MODEL as\n";
            for (int i = 0; i < n; ++i) {
                object = (myComponent)this.components.get(i);
                string = string + "def comp " + ((myComponent)object).getName() + " as\n";
                serializable = ((myComponent)object).getVariables();
                for (int j = 0; j < ((ArrayList)serializable).size(); ++j) {
                    Variable variable = (Variable)((ArrayList)serializable).get(j);
                    string = string + "var " + variable.getName() + ": ";
                    string = string + variable.getUnits() + " ";
                    string = variable.getInit() == null ? string + "{" : string + "{init: " + variable.getInit();
                    if (variable.getPub().equals("")) {
                        string = string + "};";
                    } else {
                        if (variable.getInit() != null) {
                            string = string + ",";
                        }
                        string = string + " pub: " + variable.getPub() + "};";
                    }
                    string = string + "\n";
                }
                string = string + ((myComponent)object).getEquations() + "\n";
                string = string + "enddef;\n";
            }
            string = string + this.corFromJoins() + "\n";
            string = string + this.corFromUnits() + "\n";
            string = string + "enddef;\n";
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            object = new JScrollPane(jTextArea, 22, 32);
            serializable = new JFrame("COR code");
            ((JFrame)serializable).getContentPane().add((Component)object);
            ((Window)serializable).setBounds(50, 50, 550, 550);
            ((Component)serializable).show(true);
        }

        String saveXMLString() {
            int n;
            Object object;
            String[][] stringArray;
            int n2;
            String string = "";
            int n3 = this.components.size();
            string = string + "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            string = string + "<model name=\"GUImodel\" cmeta:id=\"GUImodel\" xmlns=\"http://www.cellml.org/cellml/1.0#\" xmlns:cellml=\"http://www.cellml.org/cellml/1.0#\" xmlns:cmeta=\"http://www.cellml.org/metadata/1.0#\">\n";
            string = string + "\n\n<!-- This model was created using GUIcellML. -->\n\n";
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray = (String[][])this.components.get(n2);
                string = string + "<component";
                string = string + " name=\"" + stringArray.getName() + "\"";
                string = string + " guileft=\"" + stringArray.getLeft() + " \"";
                string = string + " guitop=\"" + stringArray.getTop() + " \"";
                string = string + " guiwidth=\"" + stringArray.getWidth() + " \"";
                string = string + " guiheight=\"" + stringArray.getHeight() + " \"";
                string = string + " guicolor=\"" + stringArray.getColor().getRed() + "," + stringArray.getColor().getGreen() + "," + stringArray.getColor().getBlue() + " \">\n";
                object = stringArray.getVariables();
                for (n = 0; n < ((ArrayList)object).size(); ++n) {
                    string = string + " \t<variable ";
                    Variable variable = (Variable)((ArrayList)object).get(n);
                    string = string + " name=\"" + variable.getName() + " \"";
                    string = string + " units=\"" + variable.getUnits() + " \"";
                    string = variable.getInit() == null ? string + "" : string + " initial_value=\"" + variable.getInit() + " \"";
                    if (!variable.getPub().equals("")) {
                        string = string + " public_interface=\"" + variable.getPub() + " \"";
                    }
                    string = string + " guicolor=\"" + variable.getColor().getRed() + "," + variable.getColor().getGreen() + "," + variable.getColor().getBlue() + " \"";
                    string = string + "/>\n";
                }
                string = string + "<math><!--\n";
                string = string + stringArray.getEquations() + "\n";
                string = string + "--></math>\n";
                string = string + "</component>\n";
            }
            n2 = this.joins.size();
            if (n2 > 0) {
                int n4;
                stringArray = new String[n2][4];
                for (n4 = 0; n4 < n2; ++n4) {
                    Join join = (Join)this.joins.get(n4);
                    stringArray[n4][0] = join.getFromc().getName();
                    stringArray[n4][1] = join.getToc().getName();
                    stringArray[n4][2] = join.getFromv().getName();
                    stringArray[n4][3] = join.getTov().getName();
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    if (stringArray[n4][0].compareTo(stringArray[n4][1]) <= 0) continue;
                    String string2 = stringArray[n4][0];
                    stringArray[n4][0] = stringArray[n4][1];
                    stringArray[n4][1] = string2;
                    string2 = stringArray[n4][2];
                    stringArray[n4][2] = stringArray[n4][3];
                    stringArray[n4][3] = string2;
                }
                Arrays.sort(stringArray, new LastFirstComparator());
                string = string + "<connection>\n";
                string = string + "<map_components component_1=\"" + stringArray[0][0] + "\" component_2=\"" + stringArray[0][1] + "\"/>\n";
                string = string + "<map_variables variable_1=\"" + stringArray[0][2] + "\" variable_2=\"" + stringArray[0][3] + "\"/>\n";
                object = stringArray[0][0] + "-" + stringArray[0][1];
                for (n = 1; n < n2; ++n) {
                    if (((String)object).equals(stringArray[n][0] + "-" + stringArray[n][1])) {
                        string = string + "<map_variables variable_1=\"" + stringArray[n][2] + "\" variable_2=\"" + stringArray[n][3] + "\"/>\n";
                    } else {
                        string = string + "</connection>\n<connection>\n";
                        string = string + "<map_components component_1=\"" + stringArray[n][0] + "\" component_2=\"" + stringArray[n][1] + "\"/>\n";
                        string = string + "<map_variables variable_1=\"" + stringArray[n][2] + "\" variable_2=\"" + stringArray[n][3] + "\"/>\n";
                    }
                    object = stringArray[n][0] + "-" + stringArray[n][1];
                }
                string = string + "</connection>\n";
            }
            for (int i = 0; i < this.units.size(); ++i) {
                object = (Unit)this.units.get(i);
                string = string + "<units ";
                string = string + " name=\"" + ((Unit)object).getName() + " \">";
                ArrayList arrayList = ((Unit)object).getSubUnits();
                for (int j = 0; j < arrayList.size(); ++j) {
                    Unit unit = (Unit)arrayList.get(j);
                    string = string + "<unit units=\"" + unit.getName();
                    if (!unit.isBare()) {
                        string = string + "\" ";
                        if (!unit.getPref().equals("")) {
                            string = string + "prefix=\"" + unit.getPref() + "\"";
                        }
                        if (unit.getExpo() != 0.0) {
                            if (!unit.getPref().equals("")) {
                                string = string + "";
                            }
                            string = string + "exponent=\"" + unit.getExpo() + "\"";
                        }
                        if (unit.getMult() != 1.0) {
                            if (!unit.getPref().equals("") || unit.getExpo() != 0.0) {
                                string = string + "";
                            }
                            string = string + "multiplyer=\"" + unit.getMult() + "\"";
                        }
                        if (unit.getOffset() != 0.0) {
                            if (!unit.getPref().equals("") || unit.getExpo() != 0.0 || unit.getMult() != 1.0) {
                                string = string + "";
                            }
                            string = string + "offset=\"" + unit.getOffset() + "\"";
                        }
                        string = string + "/>\n";
                        continue;
                    }
                    string = string + "\"/>\n";
                }
                string = string + "</units>\n";
            }
            string = string + "</model>\n";
            return string;
        }

        void addVariableToComponent(myComponent myComponent2) {
            Variable variable = new Variable(guicellml.this.vIDcount, myComponent2.getID());
            VariableOptionPanel variableOptionPanel = new VariableOptionPanel(null, true, variable);
            variableOptionPanel.setLocation(this.px + 10, this.py + 10);
            variableOptionPanel.setVisible(true);
            if (variableOptionPanel.getResponse().equals("OK")) {
                variable.setName(variableOptionPanel.getNameField());
                if (variableOptionPanel.getInitField() != null) {
                    variable.setInit(Double.parseDouble(variableOptionPanel.getInitField()));
                }
                variable.setUnits(variableOptionPanel.getUnitField());
                variable.setPub(variableOptionPanel.getPubBox());
                variable.setColor(variableOptionPanel.getColorField());
                this.clickedComp.updateVariableRows();
                variableOptionPanel.dispose();
            } else {
                variableOptionPanel.dispose();
            }
            myComponent2.addVariable(variable);
            ++guicellml.this.vIDcount;
        }

        void addComponent() {
            myComponent myComponent2 = new myComponent(guicellml.this.cIDcount);
            myComponent2.setColor(Color.gray);
            myComponent2.reshape(3, 3, 100, 60);
            this.components.add(myComponent2);
            myComponent2.setName("C" + this.components.size());
            ++guicellml.this.cIDcount;
            this.repaint();
        }

        void addJoin(Join join) {
            this.joins.add(join);
            this.repaint();
        }

        void addUnit(Unit unit) {
            this.units.add(unit);
        }

        public myComponent getComponentMouse(int n, int n2) {
            myComponent myComponent2 = null;
            for (int i = this.components.size() - 1; i >= 0; --i) {
                myComponent myComponent3 = (myComponent)this.components.get(i);
                if (!myComponent3.containsPoint(n, n2)) continue;
                myComponent2 = myComponent3;
                break;
            }
            return myComponent2;
        }

        public myComponent getComponentResizeMouse(int n, int n2) {
            myComponent myComponent2 = null;
            for (int i = this.components.size() - 1; i >= 0; --i) {
                myComponent myComponent3 = (myComponent)this.components.get(i);
                if (!myComponent3.containsResizePoint(n, n2)) continue;
                myComponent2 = myComponent3;
                break;
            }
            return myComponent2;
        }

        String corFromUnits() {
            String string = "";
            for (int i = 0; i < this.units.size(); ++i) {
                Unit unit = (Unit)this.units.get(i);
                string = string + "def unit " + unit.getName() + " from\n";
                for (int j = 0; j < unit.getSubUnits().size(); ++j) {
                    Unit unit2 = (Unit)unit.getSubUnits().get(j);
                    string = string + "unit " + unit2.getName();
                    if (!unit2.isBare()) {
                        string = string + " {";
                        if (!unit2.getPref().equals("")) {
                            string = string + "pref: " + unit2.getPref();
                        }
                        if (unit2.getExpo() != 0.0) {
                            if (!unit2.getPref().equals("")) {
                                string = string + ", ";
                            }
                            string = string + "expo: " + unit2.getExpo();
                        }
                        if (unit2.getMult() != 1.0) {
                            if (!unit2.getPref().equals("") || unit2.getExpo() != 0.0) {
                                string = string + ", ";
                            }
                            string = string + "mult: " + unit2.getMult();
                        }
                        if (unit2.getOffset() != 0.0) {
                            if (!unit2.getPref().equals("") || unit2.getExpo() != 0.0 || unit2.getMult() != 1.0) {
                                string = string + ", ";
                            }
                            string = string + "offset: " + unit2.getOffset();
                        }
                        string = string + "};\n";
                        continue;
                    }
                    string = string + ";\n";
                }
                string = string + "enddef;\n";
            }
            return string;
        }

        String corFromJoins() {
            String string = "";
            int n = this.joins.size();
            if (n > 0) {
                Object object;
                int n2;
                String[][] stringArray = new String[n][4];
                for (n2 = 0; n2 < n; ++n2) {
                    object = (Join)this.joins.get(n2);
                    stringArray[n2][0] = ((Join)object).getFromc().getName();
                    stringArray[n2][1] = ((Join)object).getToc().getName();
                    stringArray[n2][2] = ((Join)object).getFromv().getName();
                    stringArray[n2][3] = ((Join)object).getTov().getName();
                }
                for (n2 = 0; n2 < n; ++n2) {
                    if (stringArray[n2][0].compareTo(stringArray[n2][1]) <= 0) continue;
                    object = stringArray[n2][0];
                    stringArray[n2][0] = stringArray[n2][1];
                    stringArray[n2][1] = object;
                    object = stringArray[n2][2];
                    stringArray[n2][2] = stringArray[n2][3];
                    stringArray[n2][3] = object;
                }
                Arrays.sort(stringArray, new LastFirstComparator());
                String string2 = stringArray[0][0] + "-" + stringArray[0][1];
                string = string + "def map between " + stringArray[0][0];
                string = string + " and " + stringArray[0][1] + " for\n";
                string = string + "vars " + stringArray[0][2];
                string = string + " and " + stringArray[0][3] + ";\n";
                for (int i = 1; i < n; ++i) {
                    if (string2.equals(stringArray[i][0] + "-" + stringArray[i][1])) {
                        string = string + "vars " + stringArray[i][2];
                        string = string + " and " + stringArray[i][3] + ";\n";
                    } else {
                        string = string + "enddef;\n";
                        string = string + "def map between " + stringArray[i][0];
                        string = string + " and " + stringArray[i][1] + " for\n";
                        string = string + "vars " + stringArray[i][2];
                        string = string + " and " + stringArray[i][3] + ";\n";
                    }
                    string2 = stringArray[i][0] + "-" + stringArray[i][1];
                }
                string = string + "enddef;\n";
            }
            return string;
        }

        void Load(File file) {
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Object object8;
                Object object9;
                Node node;
                int n = 0;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                NodeList nodeList = document.getElementsByTagName("component");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (node2.getNodeType() != 1) continue;
                    node = (Element)node2;
                    object9 = node.getAttribute("name").trim();
                    int n2 = guicellml.this.cIDcount * 20;
                    if (!node.getAttribute("guileft").trim().equals("")) {
                        n2 = Integer.parseInt(node.getAttribute("guileft").trim());
                    }
                    int n3 = guicellml.this.cIDcount * 20;
                    if (!node.getAttribute("guitop").trim().equals("")) {
                        n3 = Integer.parseInt(node.getAttribute("guitop").trim());
                    }
                    int n4 = 200;
                    if (!node.getAttribute("guiwidth").trim().equals("")) {
                        n4 = Integer.parseInt(node.getAttribute("guiwidth").trim());
                    }
                    int n5 = 100;
                    if (!node.getAttribute("guiheight").trim().equals("")) {
                        n5 = Integer.parseInt(node.getAttribute("guiheight").trim());
                    }
                    object8 = "100,100,100";
                    if (!node.getAttribute("guicolor").trim().equals("")) {
                        object8 = node.getAttribute("guicolor").trim();
                    }
                    this.addComponent();
                    myComponent myComponent2 = (myComponent)this.components.get(guicellml.this.cIDcount - 1);
                    if (node.getElementsByTagName("math").getLength() > 0) {
                        String string = this.getEquationsFrom(file, ++n);
                        myComponent2.setEquations(string);
                    }
                    myComponent2.setName((String)object9);
                    myComponent2.reshape(n2, n3, n4, n5);
                    int n6 = ((String)object8).indexOf(",");
                    int n7 = ((String)object8).indexOf(",", n6 + 1);
                    object7 = new Color(Integer.parseInt(((String)object8).substring(0, n6)), Integer.parseInt(((String)object8).substring(n6 + 1, n7)), Integer.parseInt(((String)object8).substring(n7 + 1, ((String)object8).length())));
                    myComponent2.setColor((Color)object7);
                    object6 = node.getElementsByTagName("variable");
                    for (int j = 0; j < object6.getLength(); ++j) {
                        object5 = object6.item(j);
                        if (object5.getNodeType() != 1) continue;
                        object4 = (Element)object5;
                        object3 = object4.getAttribute("name").trim();
                        object2 = object4.getAttribute("units").trim();
                        Double d = null;
                        if (!object4.getAttribute("initial_value").trim().equals("")) {
                            d = Double.parseDouble(object4.getAttribute("initial_value").trim());
                        }
                        object = object4.getAttribute("public_interface").trim();
                        String string = "100,100,100";
                        if (!object4.getAttribute("guicolor").trim().equals("")) {
                            string = object4.getAttribute("guicolor").trim();
                        }
                        Variable variable = new Variable(guicellml.this.vIDcount, myComponent2.getID());
                        variable.setName((String)object3);
                        variable.setInit(d);
                        variable.setUnits((String)object2);
                        variable.setPub((String)object);
                        int n8 = string.indexOf(",");
                        int n9 = string.indexOf(",", n8 + 1);
                        Color color = new Color(Integer.parseInt(string.substring(0, n8)), Integer.parseInt(string.substring(n8 + 1, n9)), Integer.parseInt(string.substring(n9 + 1, string.length())));
                        variable.setColor(color);
                        ++guicellml.this.vIDcount;
                        myComponent2.addVariable(variable);
                    }
                }
                NodeList nodeList2 = document.getElementsByTagName("connection");
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    node = nodeList2.item(i);
                    if (node.getNodeType() != 1) continue;
                    object9 = (Element)node;
                    NodeList nodeList3 = object9.getElementsByTagName("map_components");
                    Element element = (Element)nodeList3.item(0);
                    String string = element.getAttribute("component_1").trim();
                    String string2 = element.getAttribute("component_2").trim();
                    object8 = object9.getElementsByTagName("map_variables");
                    for (int j = 0; j < object8.getLength(); ++j) {
                        Element element2 = (Element)object8.item(j);
                        String string3 = element2.getAttribute("variable_1").trim();
                        object7 = element2.getAttribute("variable_2").trim();
                        object6 = null;
                        Variable variable = null;
                        object5 = null;
                        object4 = null;
                        for (int k = 0; k < this.components.size(); ++k) {
                            int n10;
                            object2 = (myComponent)this.components.get(k);
                            if (((myComponent)object2).getName().equals(string)) {
                                object6 = object2;
                                for (n10 = 0; n10 < ((myComponent)object6).getVariables().size(); ++n10) {
                                    object = (Variable)((myComponent)object6).getVariables().get(n10);
                                    if (!((Variable)object).getName().equals(string3)) continue;
                                    variable = object;
                                }
                            }
                            if (((myComponent)object2).getName().equals(string2)) {
                                object5 = object2;
                                for (n10 = 0; n10 < ((myComponent)object5).getVariables().size(); ++n10) {
                                    object = (Variable)((myComponent)object5).getVariables().get(n10);
                                    if (!((Variable)object).getName().equals(object7)) continue;
                                    object4 = object;
                                }
                            }
                            if (variable == null || object4 == null) continue;
                            if (!((Variable)object4).getPub().equals("out")) break;
                            Object object10 = object5;
                            object = object4;
                            object5 = object6;
                            object4 = variable;
                            object6 = object10;
                            variable = object;
                            break;
                        }
                        object3 = new Join((myComponent)object6, variable, (myComponent)object5, (Variable)object4);
                        this.addJoin((Join)object3);
                    }
                }
                NodeList nodeList4 = document.getElementsByTagName("units");
                for (int i = 0; i < nodeList4.getLength(); ++i) {
                    object9 = nodeList4.item(i);
                    if (object9.getNodeType() != 1) continue;
                    Element element = (Element)object9;
                    String string = element.getAttribute("name").trim();
                    Unit unit = new Unit(string);
                    NodeList nodeList5 = element.getElementsByTagName("unit");
                    for (int j = 0; j < nodeList5.getLength(); ++j) {
                        Element element3 = (Element)nodeList5.item(j);
                        String string4 = element3.getAttribute("units").trim();
                        String string5 = element3.getAttribute("prefix");
                        object7 = 0.0;
                        if (!element3.getAttribute("exponent").isEmpty()) {
                            object7 = Double.parseDouble(element3.getAttribute("exponent").trim());
                        }
                        object6 = 1.0;
                        if (!element3.getAttribute("multiplyer").isEmpty()) {
                            object6 = Double.parseDouble(element3.getAttribute("multiplyer").trim());
                        }
                        Double d = 0.0;
                        if (!element3.getAttribute("offset").isEmpty()) {
                            d = Double.parseDouble(element3.getAttribute("offset").trim());
                        }
                        object5 = new Unit(string4, string5, (Double)object7, (Double)object6, d);
                        unit.addSubUnit((Unit)object5);
                    }
                    this.units.add(unit);
                }
            }
            catch (SAXParseException sAXParseException) {
                String string = "";
                string = string + "** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n";
                string = string + " " + sAXParseException.getMessage();
                System.out.println(string);
                JOptionPane.showMessageDialog(new JFrame(), string);
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                (exception == null ? sAXException : exception).printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            guicellml.this.Scroll.revalidate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String getEquationsFrom(File file, int n) {
            Object object;
            String string = "";
            StringBuffer stringBuffer = new StringBuffer();
            try {
                object = new BufferedReader(new FileReader(file));
                try {
                    String string2 = null;
                    while ((string2 = ((BufferedReader)object).readLine()) != null) {
                        stringBuffer.append(string2);
                        stringBuffer.append(System.getProperty("line.separator"));
                    }
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            object = stringBuffer.toString();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = ((String)object).indexOf("<math", n2 + 1);
                n3 = ((String)object).indexOf("</math>", n3 + 1);
            }
            String string3 = ((String)object).substring(n2 + 6, n2 + 10);
            if (string3.equals("<!--")) {
                string = ((String)object).substring(n2 + 10, n3 - 3);
                System.out.println("plus 11 is " + string3);
                System.out.println("so eq is " + string);
            } else {
                string = ((String)object).substring(n2 + 6, n3);
            }
            return string;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.draggedComp != null && this.resizeComp != null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.clickedComp = null;
            this.clickedComp = this.getComponentMouse(n, n2);
            if (this.clickedComp == null) {
                return;
            }
            if (mouseEvent.isPopupTrigger()) {
                guicellml.this.popup.show(this, n - 10, n2 - 2);
            } else if (mouseEvent.isShiftDown()) {
                this.components.remove(this.clickedComp);
                this.components.add(this.clickedComp);
            } else if (this.clickedComp.left + this.clickedComp.width > 0 && this.clickedComp.height + this.clickedComp.top > 0) {
                this.draggedComp = this.clickedComp;
                this.prevDragX = n;
                this.prevDragY = n2;
            }
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.draggedComp == null) {
                return;
            }
            if (this.clickedComp.left + this.clickedComp.width > 0 && this.clickedComp.height + this.clickedComp.top > 0) {
                if (this.getCursor().getType() == 6) {
                    this.draggedComp.reshape(this.draggedComp.getLeft(), this.draggedComp.getTop(), n - this.draggedComp.getLeft(), n2 - this.draggedComp.getTop());
                } else {
                    this.draggedComp.moveBy(n - this.prevDragX, n2 - this.prevDragY);
                }
                this.prevDragX = n;
                this.prevDragY = n2;
            }
            this.clickedComp.left = this.clickedComp.left + this.prevDragX - n;
            this.clickedComp.top = this.clickedComp.top + this.prevDragY - n2;
            this.prevDragX = n;
            this.prevDragY = n2;
            Dimension dimension = this.getPreferredSize();
            if (this.clickedComp.left + this.clickedComp.width > dimension.width) {
                this.setPreferredSize(new Dimension(this.clickedComp.left + this.clickedComp.width, dimension.height));
                guicellml.this.Scroll.revalidate();
            }
            dimension = this.getPreferredSize();
            if (this.clickedComp.top + this.clickedComp.height > dimension.height) {
                this.setPreferredSize(new Dimension(dimension.width, this.clickedComp.top + this.clickedComp.height));
                guicellml.this.Scroll.revalidate();
            }
            Rectangle rectangle = guicellml.this.Scroll.getViewport().getViewRect();
            Point point = guicellml.this.Scroll.getViewport().getViewPosition();
            if (this.clickedComp.left < point.x) {
                point.x = Math.max(0, this.clickedComp.left);
            }
            if (this.clickedComp.top < point.y) {
                point.y = Math.max(0, this.clickedComp.top);
            }
            point.x = Math.max(point.x, point.x + (this.clickedComp.left + this.clickedComp.width) - (rectangle.x + rectangle.width));
            point.y = Math.max(point.y, point.y + (this.clickedComp.top + this.clickedComp.height) - (rectangle.y + rectangle.height));
            guicellml.this.Scroll.getViewport().setViewPosition(point);
            this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.draggedComp == null) {
                return;
            }
            this.px = mouseEvent.getX();
            this.py = mouseEvent.getY();
            if (mouseEvent.isPopupTrigger()) {
                int[] nArray = this.clickedComp.variableAtPoint(this.px, this.py);
                if (nArray[0] == 3) {
                    guicellml.this.vStartpopup.show(this, this.px - 10, this.py - 2);
                } else if (nArray[0] == 1) {
                    guicellml.this.vEndpopup.show(this, this.px - 10, this.py - 2);
                } else if (nArray[0] == 2) {
                    guicellml.this.vMidpopup.show(this, this.px - 10, this.py - 2);
                } else {
                    guicellml.this.popup.show(this, this.px - 10, this.py - 2);
                }
            } else if (this.getCursor().getType() == 6) {
                this.draggedComp.reshape(this.draggedComp.getLeft(), this.draggedComp.getTop(), this.px - this.draggedComp.getLeft(), this.py - this.draggedComp.getTop());
            } else {
                this.draggedComp.moveBy(this.px - this.prevDragX, this.py - this.prevDragY);
            }
            this.repaint();
            this.draggedComp = null;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.getComponentResizeMouse(mouseEvent.getX(), mouseEvent.getY()) != null) {
                this.setCursor(new Cursor(6));
            } else {
                this.setCursor(new Cursor(0));
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.clickedComp != null) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (mouseEvent.getClickCount() == 2) {
                    myComponent myComponent2 = this.getComponentMouse(n, n2);
                    this.actionPerformed(new ActionEvent(this, 1001, "Edit Component"));
                }
            }
            this.repaint();
        }
    }
}

