// init is called once the xul page has loaded
// It checks that the installed version of zinc is valid for this particular
// zinc application.  If invalid an alert is raised, otherwise zinc is 
// initialised and the CmguiReadyFunction called.
function init()
{
  // enable UniversalXPConnect priveleges.  This has to be done on a function
  // by function basis for each function which requires these priveleges
  netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");

  // set the valid version range for this zinc application
  // in this case the range is from 0.6.0.1 to 0.6.2.*
  var minVersion = "0.6.0.1";
  var maxVersion = "0.6.3";

  if (zincCheckValidVersion(minVersion, maxVersion))
  {

	 // The zincInitialise function prepares zinc to make sure the paths are
	 // correct, initialises zinc and creates a command data object.
	 // It will also call the CmguiReadyFunction with the initialised
	 // command data object as an input argument
    zincInitialise(CmguiReadyFunction);
  }
  else
  {
    var actualVersion = zincVersion();
    alert("The installed version of zinc is not valid for this application. \n"
		+ "Version installed : " + actualVersion
		+ "\nMinimum allowable version :" + minVersion
		+ "\nMaximum allowable version :" + maxVersion + "\n");
  }
}

// CmguiReadyFunction is called once zinc has been initialised
// This function takes care of downloading all the input data files
// After all files have finished downloading the runComfile function will 
// be called
function CmguiReadyFunction(zincCommandData)
  {
    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");

	 // assign commandData object to window so we have easy access to it.
    window.commandData = zincCommandData;

	 // download files and read them into memory
    var dm = zincCreateDownloadMonitor(zincCommandData, runComfile);

    // list of files to process
    var files = [
      "cube.exnode",
      "cube.exelem"
		 ];

	 var i;
	 var filename;
	 var memoryname;

    // download each file and read into a memory block
	 for (i = 0 ;  i < files.length ; i++)
	 {
		 // in this case the files to load are in the current directory
		 // so we do not need to include a path with the filename
		 filename = files[i];

		 // for convenience we will also use the filename as the memory name
		 memoryname = files[i];

		 try
		 {
			 zincDefineMemoryBlock(dm, filename, memoryname);
		 }
		 catch (error)
		 {
			 alert ("Unable to load file " + filename);
		 }
	 }

}


// run the cmgui comfile
// This function can either call an existing comfile or run individual commands
// by using the command data executeCommand function.  This is where the bulk
// of your cmgui commands will go.
//
// Note that zinc does not provide support for perl scripting in comfiles so
// any comfiles you run should not contain any perl scripting (eg no if, for 
// or while statements).
// Also some commands will not work with zinc (eg commands that modify a window
// or try to open a scene editor).
function runComfile()
{
  netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");

  // the execute command executes the quoted command string passed as an
  // input argument.
   window.commandData.executeCommand('gfx read node memory:cube.exnode;');
   window.commandData.executeCommand('gfx read node memory:cube.exelem;');
   window.commandData.executeCommand('gfx create material blue ambient 0.2 0.2 0.9 diffuse 0.2 0.2 0.9');
   window.commandData.executeCommand('gfx create axes material blue length 1.2');
   window.commandData.executeCommand('gfx draw axes');
   window.commandData.executeCommand('gfx create material orange ambient 1 0.25 0 diffuse 1 0.25 0');
   window.commandData.executeCommand('gfx modify g_element cube node_points material orange label cmiss_number');
   window.commandData.executeCommand('gfx create material bluey ambient 0 0.25 0.5 diffuse 0 0.4 1 specular 0.5 0.5 0.5 shininess 0.3;');
   window.commandData.executeCommand('gfx modify g_element cube surfaces mat bluey');

  // get the plugin from the html page
  var plugin = document.getElementById("generalplugin");

  // create a scene viewer and hook it up to the plugin
  // when the scene viewer is ready call the sceneReadyFunction

  zincCreateSceneViewer(plugin, window.commandData,sceneReadyFunction);
}


// once the scene viewer is ready call any specific scene viewer commands
// eg change the view point
function sceneReadyFunction(sceneViewer)
{
    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");

	 // set the eyepoint, look at point and up vector for the viewer
	 sceneViewer.setLookatParametersNonSkew(-1.63919, -1.55945, 2.41471,
		 0.5, 0.5, 0.5,
		 0.389501, 0.376782, 0.840431);

    sceneViewer.viewAll();


}
