#Example_ao: Streamlines : Showing heart fibres
#
# This example shows how to use streamlines to display the
# fibre field inside the heart.
#
#----------
#
# Create the graphics window
#
gfx create window 1
gfx modify window 1 view perspective eye_point 9.70453 -289.811 -5.00082 interest_point 9.70453 6.38585 -5.00082 up_vector -1 0 6.12323e-17 view_angle 18.2876 near_clipping_plane 2.96197 far_clipping_plane 1058.51 relative_viewport ndc_placement -1 1 2 2 viewport_coordinates 0 0 1 1
#
# Load the exnode and exelem files
#
set dir example a3
gfx read nodes example heart.exnode
gfx read elements example heart.exelem
#
# Define a few materials
#
gfx create material red ambient 1 0 0 diffuse 1 0 0 emission 0 0 0 specular 0.8 0.8 0.8 alpha 1 shininess 0.8
gfx create material green ambient 0 0.6 0 diffuse 0 0.6 0 emission 0 0 0 specular 0.8 0.8 0.8 alpha 1 shininess 0.8
gfx create material bluey ambient 0 0.2 0.4 diffuse 0 0.5 1 emission 0 0 0 specular 0.5 0.5 0.5 alpha 1 shininess 0.8
gfx create material gold ambient 1 0.7 0 diffuse 1 0.7 0 emission 0 0 0 specular 1 1 0.8 alpha 1 shininess 0.8
gfx create material purple ambient 1 0 1 diffuse 1 0 1 emission 0 0 0 specular 1 1 1 alpha 1 shininess 0.74
gfx create material heart ambient 0.3 0 0.3 diffuse 1 0 0 specular 0.5 0.5 0.5 shininess 0.5
#
# By default when the three fibre angles are used as a vector they are
# generalised into a 9 component tensor.
# The first three components are a vector aligned with the fibre direction, 
# the second three components are the vector which is orthogonal to the fibre
# direction but which also lies in the sheet, and the third group of three 
# components are a vector orthogonal to the first two.
#
# Therefore by drawing stream ribbons aligned with this coordinate system
# you get ribbons which track the fibre direction with the ribbons lying
# in the sheet plane.
#
# As this happens automatically if you list the values of the fibres field
# you see the three angles.
#
gfx modify g_element heart element_points use_elements glyph point label fibres discretization "1*1*1" cell_centres material default
#
#Delete these labels.
#
gfx modify g_element heart element_points use_elements glyph point label fibres delete
#
# You can manually expand the three angles into the 9 component tensor.
#
gfx define field fibre_vector fibre_axes fibre fibres coordinate coordinates
gfx modify g_element heart element_points use_elements glyph point label fibre_vector discretization "1*1*1" cell_centres material default
#
#Delete these again.
#
gfx modify g_element heart element_points use_elements glyph point label fibre_vector delete
#
#
# Display basic streamlines representing the fibres
#
gfx mod g_e heart streamlines ribbon material green vector fibres length 100 
#
# Display surfaces of heart chambers
# 
gfx mod g_e heart surfaces exterior face xi3_0 mat heart
#
# By reordering the components of the fibre_vector field we get a 3-vector field 
# which is orthogonal to the fibre axes but still lies in the sheet. Note this
# makes a left-handed coordinate system unless we reverse the fibre direction,
# but this makes no difference for streamlines:
gfx define field sheet_vector composite fibre_vector.4 fibre_vector.5 fibre_vector.6 fibre_vector.1 fibre_vector.2 fibre_vector.3 fibre_vector.7 fibre_vector.8 fibre_vector.9
gfx mod g_e heart streamlines ribbon material gold vector sheet_vector length 100
#
# Streamlines can be rendered with data and spectrums in the normal way but
# can also show a value which is proportional to their length.  This is particularly
# useful in fields, unlike the fibre system, where the velocity (magnitude) of the
# vector field is changing.
#
gfx mod g_e heart streamlines ribbon material green vector fibres length 100 travel_scalar
gfx mod spectrum default auto
#
# There are additional options, all accessible through the graphical element
# editor for changing the profile of the streamline (ribbon is the current option, extruded rectangles
# or extruded elipses are other options), a shortcut for showing the magnitude of the tracked field
# as data and for restricting the seed to only a singular specific element.
#
# Additionally using the old commands you can seed streamlines at the points described by
# a data group which has an element_xi field.  See the seed_data_group and seed_data_field
# under gfx create streamlines.
