#Example_a7: Fields, spectrums and iso_surfaces: geothermal field
#
# Geothermal models have to keep track of numerous state variables such as
# temperature, pressure, density, vapour saturation, fluxes and more. Cmgui
# provides the ability to plot such fields (or field components), coloured by
# spectrums, over any lines, surfaces or other graphics it can produce.
# Furthermore, when fields are defined over a volume, iso-surfaces - surfaces of
# constant data field value - can also be computed and displayed.
#
# This example shows the Wairakei Broadlands geothermal field, modelled by the
# MULKOM package using finite volumes. The data set has many fields defined
# over it, only a few of which will be looked at here. Note that this is a large
# example and may be tedious to view on a slow computer or network.
#
# Be sure to run the commands in this example in the order they are presented,
# and not all at once. Comments and instructions for things you can do are given
# between these commands.
#
#----------
#
# Create some materials for use later.
gfx create material red ambient 1 0.2 0.2 diffuse 1 0.2 0.2
gfx create material green ambient 0.2 1 0.2 diffuse 0.2 1 0.2
gfx create material blue ambient 0.2 0.2 1 diffuse 0.2 0.2 1
gfx create material trans_brown ambient 0.6 0.3 0.2 diffuse 0.6 0.3 0.2 alpha 0.8
gfx cre mat bluey ambient 0 0.2 0.4 diffuse 0 0.5 1 specular 0.5 0.5 0.5 shininess 0.8
gfx cre mat gold ambient 1 0.7 0 diffuse 1 0.7 0 specular 1 1 0.8 shininess 0.8
#
# Read in the nodes and elements for the Wairakei Broadlands field.
gfx read node example wai1225.exnode
gfx read elem example wai1225.exelem
#
# Open the graphics window.
gfx create window 1
#
# Draw axes close to the mesh and of appropriate size and colour to be seen.
# Note that the town of Taupo is at approximately at coordinate
# (265400,596800,367), so we choose this as the origin for the axes.
gfx create axes material blue origin 265400 596800 367 length 5000
gfx draw axes
#
# Now adjust the view to see all the model in perspective.
gfx mod win 1 image view_all
gfx mod win 1 view perspective
#
# Change the lines to be on the exterior only, and reduce discretization.
gfx modify g_element wai1225 lines delete
gfx mod g_e wai1225 general element_discretization 1
gfx mod g_e wai1225 lines exterior
#
# Now add the surface at which temperature = 100. Colour it gold.
gfx mod g_e wai1225 iso_surfaces iso_scalar Temperature.value iso_value 100 material gold
#
# Rotate and zoom in on the model to have a good look at it. Note especially the
# proximity of Taupo to this high temperature zone.
#
# For the remainder of this example we will use the scene editor to
# vary the fields we look at.  We need to first define the fields that we will be visualising,
# otherwise they are not available as options in the scene editor.
gfx define field Temperature.value component Temperature.value
gfx define field Pressure.value component Pressure.value
#
# Next we open the scene editor.
gfx edit scene
#
# First select the iso_surfaces that were created earlier and experiment with
# different iso_values from 0 to the maximum temperature of just over 250
# degrees. Set it to a value of 150 and change its material to 'bluey'. Now add
# a second iso_surface, with material 'trans_brown' and 'Temperature.value=100'.
# This new surface must be drawn after the blue surface to achieve the desired
# effect of seeing the 150 surface through the 100 surface. You may wish to make
# the lines invisible when looking at this.
#
# Now delete one of the iso-surfaces and ensure the remaining one uses material
# 'gold' and is showing the surface of temperature=100. For this iso_surface,
# click 'Data' and choose field component 'Pressure.value'. Now click OK.
# The surfaces are probably black. What you have done is told the program to ask
# the "spectrum" called 'default' to supply the colour of the surface based on
# the value of the Pressure field (which has only one component). The spectrum
# currently does not know the range of that field over the graphics object you
# have drawn; we now have to get it to find the range. Open the spectrum editor.
gfx edit spectrum
#
# A spectrum is a mapping from the value of a field to a colour. Cmgui allows
# a huge degree of flexibility in specifying this mapping and the colours that
# are applied. You should now be looking at spectrum 'default' which currently
# draws a rainbow for field values ranging from value 0 to 1. You can tell the
# spectrum to automatically update its range to match the data range of all
# graphics objects using it simply by pressing the 'Autorange' button on the
# this editor (the same option is available from the 'gfx modify spectrum'
# commands). Since the editor, like all others works on a local copy of the
# object concerned, you must click on 'Apply' to copy the changes to the real
# object. Do this and look at the result.
#
# You should create a separate spectrum for each field/component you wish to
# plot. Temperature and pressure values, for example, are vastly different in
# magnitude and therefore do not belong on the same scale. Select the 'default'
# spectrum on the editor, click 'Rename' and change its name to 'Pressure'. Its
# name will be updated in the scene editor as soon as you press ENTER.
# You should use this spectrum whenever you are plotting this Pressure
# field (you may have a completely different pressure in a different region of
# the model, in which case you may choose to give it its own spectrum). If you
# wish to exaggerate the scale or emphasis certain parts of the range, you may
# do so by adding extra settings to the spectrum. The following exercise shows
# how to do this.
#
# On the spectrum editor, click 'Create' to make a new spectrum and rename it
# 'Temperature'. Hide the coloured iso_surfaces using their visibility toggle on
# the graphical element editor. Add surfaces with the 'exterior' flag set and
# plot scalar 'Temperature.value' with the Temperature spectrum. Autorange the
# spectrum to see the result. The outside surface will be rainbow coloured, and
# red where it is hottest.
#
# Suppose we are not so interested in areas where the temperature is under 100
# degrees. We can colour this part of the spectrum differently. Click 'Add' on
# the Spectrum editor to add more settings to the Temperature spectrum. It will
# be a copy of the original rainbow, with the same range of approx. 20 to 263.
# Change its lower limit to 100 and toggle 'Reverse' to change the direction of
# the rainbow. Now select the first settings item and change its colour to
# Green. Make sure it is not reversed either and that its upper limit is 100.
# You also need to switch off 'Extend below' and 'Extend above' on both parts 
# of the spectrum.
# Click apply to see the changes on the graphics window. The hottest region is
# now blue, with "unimportant" regions coloured green.
#
# With this kind of smooth colouring it can be hard to tell the exact
# temperature at a specific point on the surface. By overlaying the colour with
# contour bands, this situation is greatly improved. Add another component to
# the Temperature spectrum of type 'Contour Bands' and apply it. You can adjust
# the number and thickness of the bands on the editor.
#
# Note that there is a visibility beside each component making up the spectrum.
# Experiment turning them on and off and applying the changes.
#
# You may notice that abrupt changes in colour on the spectrum, such as where
# green changes to red in this example cause some rather bizarre shading
# effects. Increasing the element discretization of the graphical element
# narrows the band where this problem occur, but only ridiculously high
# discretization values will fix it completely. 'Contour Bands' and 'Step' types
# do not suffer from these problems since they use texture mapping to apply the
# spectrum. However, since only one texture can be used at a time, you will not
# get the correct behaviour with these types unless you use just one set of
# bands OR just one step function.
#
# Spectrums combine their colours with those of the material you gave to the
# graphics object. If that material was semi-transparent, it should remain so.
# The components making up the spectrum may override the ambient, diffuse,
# emissive and specular colour components of the material. You can even have the
# spectrum vary the transparency (alpha) of the object according to a field
# value. The editor option 'Clear colour before settings' is important here.
# When plotting a green spectrum, the red and blue components of the original
# material will be cleared if this button is set, and unchanged if it is not.
# Red and blue colours apply similarly to their component.
#
# Covering all the capabilities of spectrums is beyond the scope of this one
# example. Feel free to view other fields defined for this example and
# experiment with other spectrum options.
#
# Note that you can get cmgui to list the commands needed to reproduce a
# particular spectrum for putting in your .com files using, eg:
gfx list spectrum Temperature commands
#
# VRML is a 3D file format that is designed to be incoporated into the internet.
# Viewers are freely available for the PC, Mac and SGI, 
# such as CosmoPlayer by SGI.(cosmosoftware.com) and plugin to the popular
# browsers.  This enables you to make your models available on the web to the
# general public without having to provide proprietry software.
# This command exports all the implemented graphics object types from the default
# scene to the file wai1225.wrl in the directory Cmgui started.
gfx export vrml file wai1225.wrl
# The file can then be viewed with a VRML player or edited with a VRML editor
# such as CosmoWorlds.
#
#Set the command prompt to 'gfx' for entering further commands.
gfx
#
#----------
#
