#Example_a2: Scene editor, lighting: decorating a cube
#
# Provided you have placed your elements (and nodes) into appropriate groups,
# giving them a graphical rendition is as simple as a few clicks in the
# 'scene editor'. This example demonstrates how to use this editor to make a
# cube look really stylish. It shows off several features such as materials,
# lighting and transparency, and shows how to move nodes visually with the
# mouse.
#
# Be sure to run the commands in this example in the order they are presented,
# and not all at once. Comments and instructions for things you can do are
# given between these commands.
#
#----------
#
# Create a few materials in addition to the default for use later. Material
# 'kermit' is green and shiny, 'trans_purple' is a semi-transparent purple
# colour, while 'gold' looks somewhat like the precious metal.
gfx create material kermit ambient 0 0.7 0.2 diffuse 0 0.7 0.2 specular 1 1 1 shininess 0.5;
gfx create material trans_purple ambient 0.4 0 0.9 diffuse 0.4 0 0.9 alpha 0.5;
gfx create material gold ambient 1 0.7 0 diffuse 1 0.7 0 specular 1 1 0.8 shininess 0.8;
#
# Read in the cube and draw axes.
gfx create axes length 1.2 as my_axes
gfx draw my_axes
gfx read nodes example cube.exnode
gfx read elements example cube.exelem
#
# Note that you do not need a graphics window open to set axes or create
# graphics - they exist in the default 'scene'. A graphics window is one of the
# tools available to view the scene. Other ways include exporting to VRML or
# Alias|Wavefront formats. Now open the graphics window and set the view you
# want by dragging in it with the mouse.
gfx create window 1
#
# Now open the scene editor, either by selecting it from the 'Graphics'
# menu, or by typing:
gfx edit scene
#
# Spend some time looking at the parts that make up the editor. At the very top
# you can set which object in the scene you are looking editing. Every element
# group may have a different rendition in every scene. Usually you will only
# use the default scene. To the left of each item, for example 'cube', is a
# toggle button for changing its visibility. Click it off, then on again to see
# the whole cube disappear and reappear in the graphics window.
#
# Visibility can also be controlled by commands:
gfx set visibility cube off
gfx set visibility cube on
#
# Below the list of objects in the scene is some information and controls for
# manipulating them. There are up and down arrows for changing the order in
# which objects are drawn. The 'Auto' button controls whether changes you make
# in the areas below are applied immediately, and whether changes made
# externally are automatically reflected in the editor. Normally you should
# leave this on, but if your graphics are slow to create and you wish to
# make several changes before they are rebuilt, disable this function. You
# will then need to click on the 'Apply' and 'Revert' to bring the rest of the
# program in line with your changes, or vice-versa.
#
# If you select an object such as 'cube' that represents part of your model,
# the remainder of the dialog will be filled with the graphical element editor.
# This editor contains a list of graphics making up the rendition of group cube.
# Initially, it shows just lines, and if selected, the parameters
# that make up the lines are available for editing below the list of graphics.
# To the left of each listed graphic is a visibility control. Click on this
# control to hide the lines so we can show more interesting graphics instead.
# The change in visibility takes place instantly because "Auto Apply" is on.
#
# The lines can also be hidden with the following text command:
gfx modify g_element cube lines invisible
#
# Along one line of the editor you should see four buttons to add, delete, move
# up and move down an item. To the left of the 'Add' button is a menu for
# selecting which type of graphic you wish to add. Choose 'cylinders' then
# click 'Add'. Change the Material to gold, and enter a value of 0.02 in the
# 'constant radius' box. If you look really closely at the cylinders you will
# see that they are in fact 6-sided polygons. You can control the number of
# segments around the cylinders by clicking on the "+" button to expand the
# 'General settings' and changing 'Circle discretization' to, say, 12.
#
# The following text commands do the same as the above interactions (note that
# setting the discretization first means the graphics are not rebuilt twice):
gfx modify g_element cube general circle_discretization 12
gfx modify g_element cube cylinders constant_radius 0.02 material gold
#
# You may have to enlarge the window, or hide the general settings by clicking
# on the '-' button, to see all of the editor.
#
# Now add semi-transparent surfaces by selecting 'surfaces', 'Add', changing
# the material to trans_purple. This produces surface out of all the 2-D
# elements in the group. Element groups may contain 3-D, 2-D and
# 1-D elements, and by reference, [0-D] nodes. While most graphic types work on
# just one dimensionality, some allow you to choose the dimension of elements
# to be used.
#
# The following text command adds the semitransparent surfaces:
gfx modify g_element cube surfaces material trans_purple render_shaded
#
# Select 'surfaces' then 'Add' again, change the material to kermit, select
# 'Face', then apply. Look at the model. This should have made the surface
# xi1=0 green, but it had no effect! The reason is that the purple surfaces
# were drawn first, and despite being translucent, they hide the other surface.
# The solution is to draw the face before the rest of the surfaces by moving
# it up the list with the 'Up' button. To get the best transparency effects
# draw objects from the back (or inside) to the front (or outside).
# (Note: Another [imperfect] solution that does not require reordering of the
# graphics is to use the 'slow_transparency' option with the
# 'gfx modify window 1 set' command).
#
# The following line will add the green face for rendering in the right order:
gfx modify g_element cube surfaces face xi1_0 material kermit render_shaded position 3
#
# The geometry of the element is described by the field "coordinates", which
# has three components: x, y and z. Now we want to draw the surface inside the
# cube at which coordinate "x" is a constant value, say 0.5. First we have to
# make the x component of the "coordinates" field look like a field itself:
gfx define field coordinates.x component coordinates.x
# In the graphical element editor select 'iso_surfaces', 'Add', and complete
# the line 'coordinates.x = 0.5'. You will have to move it up before the
# purple surfaces in the list before it is visible. In later examples you will
# see much more interesting fields plotted with iso-surfaces.
# Again the text command equivalent is:
gfx modify g_element cube iso_surfaces iso_scalar coordinates.x iso_value 0.5 use_elements material default render_shaded position 4
#
# Now add 'node_points', with "cmiss_number" as the label field. You can now
# see the node numbers, although they will be partly obscured by the cylinders.
# There is also a small dot beside the number marking the exact nodal position.
gfx modify g_element cube node_points glyph point label cmiss_number select_on material default selected_material default_selected
#
# Choose the node tool icon in the graphics window. Click on the nodes to
# select them - they will then be drawn in the "selected material" chosen in
# the graphical element editor. Dragging across several nodes displays a rubber
# band for group selection. Click a second time on the node tool icon to bring
# up a dialog for controlling its behaviour. Activate the "edit" control. Now
# the node tool is able to move nodes in the plane of the window. Click on a
# node in the graphics window and drag it to a new position. Shift-click on
# other nodes to add or remove them from the current selection. Group selection
# with and without the shift-key also enables several nodes to be selected for
# editing.
# Activate edit capability in the node tool with the command:
gfx node_tool edit
# 
# Remember you can transform the view by returning to 'Transform' mode, or
# hold down the 'Ctrl' key to temporarily transform the view with the mouse
# without leaving the control of the node tool.
#
# Move the nodes on the green surface to make it quite curved. Transform it to
# see the light glistening off its shiny surface. You will notice that this
# "specular highlight" is rather cheesy, giving away the polygonal nature of
# the surface. Display the general settings on the graphical element editor.
# The 'element discretization' displays the number of segments used to draw
# curves in the xi1*xi2*xi3 directions. The default of 4 is adequate in many
# cases, although 1 is fine for the cube - until it is distorted. Enter '16' in
# this box to discretizes lines into 16 segments, surfaces into 16*16 facets
# and volumes - used to calculate iso_surfaces - into 16*16*16 cells.
# Consequently, it takes a bit longer to produce the graphics.
# You may briefly see a busy cursor while this takes place. (Remember this is
# only a one element model... be very careful with big discretizations on large
# models; it may take several minutes to do what you ask for!).
# Adjust the element discretization up with:
gfx modify g_element cube general element_discretization "16*16*16"
#
# Now rotate the model to see nice, round specular highlights. Use higher
# discretization values for curved surfaces, when accurate lighting is required
# and when producing output for presentation.
#
# If you have produced a nice rendition with the graphical element edito, you
# will be please to know that there is an easy way to produce the text commands
# for reproducing it - for putting in your own .com file. To get the commands
# for rebuilding the cube as you see it, enter:
gfx list g_element cube commands
# Select and paste the commands into your .com file. (Had you omitted the
# keyword 'commands' in the above, a different list is produced, more useful
# for editing the group with text commands.) Note that the listed commands are
# more exhaustive than those shown in this command file. Many of the settings
# have reasonable defaults that you do not have to enter every time, thus
# shortening the commands.
#
# You have now used lines, surfaces, cylinders, iso-surfaces and node_points.
# You can't create fibres without having a fibre field in your elements, while
# volumes require a volume texture. These and other graphics are left for later
# examples.
#
# As a final exercise, we will take a look at lighting your object. Initially
# there is one light called 'default' which is placed in each window. It works
# like a head lamp in that it stays in the same position relative to the
# viewer. Have a look at the parameters of this light by entering:
gfx list light default
# The basic coordinate system of the graphics window is x to the right, y up,
# and z out of the screen. From the parameters you will see that the default
# light is mostly in to the screen and partly down. Now change it to point
# straight into the screen.
gfx mod light default dir 0 0 -1
# Change it to a spot light. Note that you'll have to set a sensible position
# for the spot light if it is pointing at some other angle to the object -
# otherwise it may not be shining on it!
gfx mod light default spot
# Change the light back to an infinite source (also called a directional light)
# and make it point straight down on the object.
gfx mod light default infinite dir 0 -1 0
# Now remove the light from the window so that the object is only lit by
# ambient light (which is set by the light model - see gfx modify lmodel ??).
gfx mod win 1 image remove_light default
# Add the default light to the default scene.
gfx mod scene default add_light default
# The light now maintains its position and orientation relative to the scene,
# not the viewer. Now restore lighting to how it was originally.
gfx mod scene default remove_light default
gfx mod win 1 image add_light default
gfx mod light default dir 0 -0.5 -1
#
# Set the command prompt to gfx.
gfx
#
#----------
#
# TIPS:
#
# Feel free to experiment with the features of cmgui, esp. at the end of this
# and other examples. Switch materials, draw different surfaces, show and hide
# graphics. You have already seen several graphical materials with interesting
# properties. Start up the 'graphical material editor' from the 'Tools' menu,
# create or modify existing materials and apply the changes to see how they
# affect the result.
#
# You can create extra lights varying in position, direction, colour and type
# using the 'gfx create light' command, and add them to windows and scenes.
# Current OpenGL implementations limit the total number of lights in an image
# to 8, but this is ample for most users. Experimenting with different material
# s, lights and light models will help you make a more impressive image - or
# make a garrish mess.
#
